/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.cm;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.cm.IChangeRequest;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/cm#")
@OslcName(value="ChangeRequest")
@OslcResourceShape(title="ChangeRequest Resource Shape", describes={"http://open-services.net/ns/cm#ChangeRequest"})
public class ChangeRequest
extends AbstractResource
implements IChangeRequest {
    private String shortTitle;
    private String description;
    private String title;
    private String identifier;
    private Set<String> subject = new HashSet<String>();
    private Set<Link> creator = new HashSet<Link>();
    private Set<Link> contributor = new HashSet<Link>();
    private Date created;
    private Date modified;
    private Set<Link> serviceProvider = new HashSet<Link>();
    private Set<Link> instanceShape = new HashSet<Link>();
    private Link discussedBy;
    private Date closeDate;
    private String status;
    private Boolean closed;
    private Boolean inProgress;
    private Boolean fixed;
    private Boolean approved;
    private Boolean reviewed;
    private Boolean verified;
    private Set<Link> relatedChangeRequest = new HashSet<Link>();
    private Set<Link> affectsPlanItem = new HashSet<Link>();
    private Set<Link> affectedByDefect = new HashSet<Link>();
    private Set<Link> tracksRequirement = new HashSet<Link>();
    private Set<Link> implementsRequirement = new HashSet<Link>();
    private Set<Link> affectsRequirement = new HashSet<Link>();
    private Set<Link> tracksChangeSet = new HashSet<Link>();
    private Set<Link> parent = new HashSet<Link>();
    private Set<Link> priority = new HashSet<Link>();
    private Link state;
    private Set<Link> authorizer = new HashSet<Link>();

    public ChangeRequest() {
    }

    public ChangeRequest(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"changeRequest", ChangeRequest.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        String result = "";
        result = asLocalResource ? result + "{a Local ChangeRequest Resource} - update ChangeRequest.toString() to present resource as desired." : String.valueOf(this.getAbout());
        result = String.format("[%s]: %s (Change Request; id=%s)", this.getShortTitle(), this.getTitle(), this.getIdentifier());
        return result;
    }

    @Override
    public void addSubject(String subject) {
        this.subject.add(subject);
    }

    @Override
    public void addCreator(Link creator) {
        this.creator.add(creator);
    }

    @Override
    public void addContributor(Link contributor) {
        this.contributor.add(contributor);
    }

    @Override
    public void addServiceProvider(Link serviceProvider) {
        this.serviceProvider.add(serviceProvider);
    }

    @Override
    public void addInstanceShape(Link instanceShape) {
        this.instanceShape.add(instanceShape);
    }

    @Override
    public void addRelatedChangeRequest(Link relatedChangeRequest) {
        this.relatedChangeRequest.add(relatedChangeRequest);
    }

    @Override
    public void addAffectsPlanItem(Link affectsPlanItem) {
        this.affectsPlanItem.add(affectsPlanItem);
    }

    @Override
    public void addAffectedByDefect(Link affectedByDefect) {
        this.affectedByDefect.add(affectedByDefect);
    }

    @Override
    public void addTracksRequirement(Link tracksRequirement) {
        this.tracksRequirement.add(tracksRequirement);
    }

    @Override
    public void addImplementsRequirement(Link implementsRequirement) {
        this.implementsRequirement.add(implementsRequirement);
    }

    @Override
    public void addAffectsRequirement(Link affectsRequirement) {
        this.affectsRequirement.add(affectsRequirement);
    }

    @Override
    public void addTracksChangeSet(Link tracksChangeSet) {
        this.tracksChangeSet.add(tracksChangeSet);
    }

    @Override
    public void addParent(Link parent) {
        this.parent.add(parent);
    }

    @Override
    public void addPriority(Link priority) {
        this.priority.add(priority);
    }

    @Override
    public void addAuthorizer(Link authorizer) {
        this.authorizer.add(authorizer);
    }

    @Override
    @OslcName(value="shortTitle")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcDescription(value="Shorter form of dcterms:title for the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getShortTitle() {
        return this.shortTitle;
    }

    @Override
    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcDescription(value="Descriptive text about resource represented as rich text in XHTML content. SHOULD include only content that is valid and suitable inside an XHTML <div> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription() {
        return this.description;
    }

    @Override
    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle() {
        return this.title;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Set<String> getSubject() {
        return this.subject;
    }

    @Override
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator() {
        return this.creator;
    }

    @Override
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor() {
        return this.contributor;
    }

    @Override
    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated() {
        return this.created;
    }

    @Override
    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified() {
        return this.modified;
    }

    @Override
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape() {
        return this.instanceShape;
    }

    @Override
    @OslcName(value="discussedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#discussedBy")
    @OslcDescription(value="A series of notes and comments about this resource.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/core#Discussion"})
    @OslcReadOnly(value=false)
    public Link getDiscussedBy() {
        return this.discussedBy;
    }

    @Override
    @OslcName(value="closeDate")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#closeDate")
    @OslcDescription(value="The date at which no further activity or work is intended to be conducted.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCloseDate() {
        return this.closeDate;
    }

    @Override
    @OslcName(value="status")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#status")
    @OslcDescription(value="Used to indicate the status of the change request based on values defined by the service provider. Most often a read-only property. Some possible values may include: 'Submitted', 'Done', 'InProgress', etc.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getStatus() {
        return this.status;
    }

    @Override
    @OslcName(value="closed")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#closed")
    @OslcDescription(value="Whether or not the Change Request is completely done, no further fixes or fix verification is needed.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isClosed() {
        return this.closed;
    }

    @Override
    @OslcName(value="inProgress")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#inProgress")
    @OslcDescription(value="Whether or not the Change Request in a state indicating that active work is occurring. If oslc_cm:inprogress is true, then oslc_cm:fixed and oslc_cm:closed must also be false")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    @OslcName(value="fixed")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#fixed")
    @OslcDescription(value="Whether or not the Change Request has been fixed.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isFixed() {
        return this.fixed;
    }

    @Override
    @OslcName(value="approved")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#approved")
    @OslcDescription(value="Whether or not the Change Request has been approved.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isApproved() {
        return this.approved;
    }

    @Override
    @OslcName(value="reviewed")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#reviewed")
    @OslcDescription(value="Whether or not the Change Request has been reviewed.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isReviewed() {
        return this.reviewed;
    }

    @Override
    @OslcName(value="verified")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#verified")
    @OslcDescription(value="Whether or not the resolution or fix of the Change Request has been verified.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isVerified() {
        return this.verified;
    }

    @Override
    @OslcName(value="relatedChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#relatedChangeRequest")
    @OslcDescription(value="This relationship is loosely coupled and has no specific meaning. It is likely that the target resource will be an oslc_cm:ChangeRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getRelatedChangeRequest() {
        return this.relatedChangeRequest;
    }

    @Override
    @OslcName(value="affectsPlanItem")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectsPlanItem")
    @OslcDescription(value="Change request affects a plan item. It is likely that the target resource will be an oslc_cm:ChangeRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getAffectsPlanItem() {
        return this.affectsPlanItem;
    }

    @Override
    @OslcName(value="affectedByDefect")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectedByDefect")
    @OslcDescription(value="Change request is affected by a reported defect. It is likely that the target resource will be an oslc_cm:ChangeRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/cm#Defect"})
    @OslcReadOnly(value=false)
    public Set<Link> getAffectedByDefect() {
        return this.affectedByDefect;
    }

    @Override
    @OslcName(value="tracksRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#tracksRequirement")
    @OslcDescription(value="Tracks the associated Requirement or Requirement ChangeSet resources. It is likely that the target resource will be an oslc_rm:Requirement but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    public Set<Link> getTracksRequirement() {
        return this.tracksRequirement;
    }

    @Override
    @OslcName(value="implementsRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#implementsRequirement")
    @OslcDescription(value="Implements associated Requirement. It is likely that the target resource will be an oslc_rm:Requirement but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    public Set<Link> getImplementsRequirement() {
        return this.implementsRequirement;
    }

    @Override
    @OslcName(value="affectsRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectsRequirement")
    @OslcDescription(value="Change request affecting a Requirement. It is likely that the target resource will be an oslc_rm:Requirement but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    public Set<Link> getAffectsRequirement() {
        return this.affectsRequirement;
    }

    @Override
    @OslcName(value="tracksChangeSet")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#tracksChangeSet")
    @OslcDescription(value="Tracks SCM change set resource. It is likely that the target resource will be an oslc_scm:ChangeSet but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/config#ChangeSet"})
    @OslcReadOnly(value=false)
    public Set<Link> getTracksChangeSet() {
        return this.tracksChangeSet;
    }

    @Override
    @OslcName(value="parent")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#parent")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    public Set<Link> getParent() {
        return this.parent;
    }

    @Override
    @OslcName(value="priority")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#priority")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/cm#Priority"})
    @OslcReadOnly(value=false)
    public Set<Link> getPriority() {
        return this.priority;
    }

    @Override
    @OslcName(value="state")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#state")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/cm#State"})
    @OslcReadOnly(value=false)
    public Link getState() {
        return this.state;
    }

    @Override
    @OslcName(value="authorizer")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#authorizer")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Agent"})
    @OslcReadOnly(value=false)
    public Set<Link> getAuthorizer() {
        return this.authorizer;
    }

    @Override
    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setSubject(Set<String> subject) {
        this.subject.clear();
        if (subject != null) {
            this.subject.addAll(subject);
        }
    }

    @Override
    public void setCreator(Set<Link> creator) {
        this.creator.clear();
        if (creator != null) {
            this.creator.addAll(creator);
        }
    }

    @Override
    public void setContributor(Set<Link> contributor) {
        this.contributor.clear();
        if (contributor != null) {
            this.contributor.addAll(contributor);
        }
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public void setServiceProvider(Set<Link> serviceProvider) {
        this.serviceProvider.clear();
        if (serviceProvider != null) {
            this.serviceProvider.addAll(serviceProvider);
        }
    }

    @Override
    public void setInstanceShape(Set<Link> instanceShape) {
        this.instanceShape.clear();
        if (instanceShape != null) {
            this.instanceShape.addAll(instanceShape);
        }
    }

    @Override
    public void setDiscussedBy(Link discussedBy) {
        this.discussedBy = discussedBy;
    }

    @Override
    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    @Override
    public void setInProgress(Boolean inProgress) {
        this.inProgress = inProgress;
    }

    @Override
    public void setFixed(Boolean fixed) {
        this.fixed = fixed;
    }

    @Override
    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    @Override
    public void setReviewed(Boolean reviewed) {
        this.reviewed = reviewed;
    }

    @Override
    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    @Override
    public void setRelatedChangeRequest(Set<Link> relatedChangeRequest) {
        this.relatedChangeRequest.clear();
        if (relatedChangeRequest != null) {
            this.relatedChangeRequest.addAll(relatedChangeRequest);
        }
    }

    @Override
    public void setAffectsPlanItem(Set<Link> affectsPlanItem) {
        this.affectsPlanItem.clear();
        if (affectsPlanItem != null) {
            this.affectsPlanItem.addAll(affectsPlanItem);
        }
    }

    @Override
    public void setAffectedByDefect(Set<Link> affectedByDefect) {
        this.affectedByDefect.clear();
        if (affectedByDefect != null) {
            this.affectedByDefect.addAll(affectedByDefect);
        }
    }

    @Override
    public void setTracksRequirement(Set<Link> tracksRequirement) {
        this.tracksRequirement.clear();
        if (tracksRequirement != null) {
            this.tracksRequirement.addAll(tracksRequirement);
        }
    }

    @Override
    public void setImplementsRequirement(Set<Link> implementsRequirement) {
        this.implementsRequirement.clear();
        if (implementsRequirement != null) {
            this.implementsRequirement.addAll(implementsRequirement);
        }
    }

    @Override
    public void setAffectsRequirement(Set<Link> affectsRequirement) {
        this.affectsRequirement.clear();
        if (affectsRequirement != null) {
            this.affectsRequirement.addAll(affectsRequirement);
        }
    }

    @Override
    public void setTracksChangeSet(Set<Link> tracksChangeSet) {
        this.tracksChangeSet.clear();
        if (tracksChangeSet != null) {
            this.tracksChangeSet.addAll(tracksChangeSet);
        }
    }

    @Override
    public void setParent(Set<Link> parent) {
        this.parent.clear();
        if (parent != null) {
            this.parent.addAll(parent);
        }
    }

    @Override
    public void setPriority(Set<Link> priority) {
        this.priority.clear();
        if (priority != null) {
            this.priority.addAll(priority);
        }
    }

    @Override
    public void setState(Link state) {
        this.state = state;
    }

    @Override
    public void setAuthorizer(Set<Link> authorizer) {
        this.authorizer.clear();
        if (authorizer != null) {
            this.authorizer.addAll(authorizer);
        }
    }
}

