/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.auto;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.auto.IParameterInstance;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/auto#")
@OslcName(value="ParameterInstance")
@OslcResourceShape(title="ParameterInstance Resource Shape", describes={"http://open-services.net/ns/auto#ParameterInstance"})
public class ParameterInstance
extends AbstractResource
implements IParameterInstance {
    private String name;
    private String value;
    private String description;
    private Set<Link> type = new HashSet<Link>();
    private Set<Link> instanceShape = new HashSet<Link>();
    private Set<Link> serviceProvider = new HashSet<Link>();

    public ParameterInstance() {
    }

    public ParameterInstance(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"parameterInstance", ParameterInstance.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        String result = "";
        result = asLocalResource ? result + "{a Local ParameterInstance Resource} - update ParameterInstance.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addType(Link type) {
        this.type.add(type);
    }

    @Override
    public void addInstanceShape(Link instanceShape) {
        this.instanceShape.add(instanceShape);
    }

    @Override
    public void addServiceProvider(Link serviceProvider) {
        this.serviceProvider.add(serviceProvider);
    }

    @Override
    @OslcName(value="name")
    @OslcPropertyDefinition(value="http://xmlns.com/foaf/0.1/name")
    @OslcDescription(value="The full name of a person expressed as simple text string.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getName() {
        return this.name;
    }

    @Override
    @OslcName(value="value")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#value")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getValue() {
        return this.value;
    }

    @Override
    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcDescription(value="Descriptive text about resource represented as rich text in XHTML content. SHOULD include only content that is valid and suitable inside an XHTML <div> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription() {
        return this.description;
    }

    @Override
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcDescription(value="The resource type URIs")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Set<Link> getType() {
        return this.type;
    }

    @Override
    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape() {
        return this.instanceShape;
    }

    @Override
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setType(Set<Link> type) {
        this.type.clear();
        if (type != null) {
            this.type.addAll(type);
        }
    }

    @Override
    public void setInstanceShape(Set<Link> instanceShape) {
        this.instanceShape.clear();
        if (instanceShape != null) {
            this.instanceShape.addAll(instanceShape);
        }
    }

    @Override
    public void setServiceProvider(Set<Link> serviceProvider) {
        this.serviceProvider.clear();
        if (serviceProvider != null) {
            this.serviceProvider.addAll(serviceProvider);
        }
    }
}

