/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.am;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.am.IResource;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/am#")
@OslcName(value="Resource")
@OslcResourceShape(title="Resource Resource Shape", describes={"http://open-services.net/ns/am#Resource"})
public class Resource
extends AbstractResource
implements IResource {
    private Set<Link> contributor = new HashSet<Link>();
    private Date created;
    private Set<Link> creator = new HashSet<Link>();
    private String description;
    private String identifier;
    private Date modified;
    private URI source;
    private String title;
    private Set<String> type = new HashSet<String>();
    private Set<Link> instanceShape = new HashSet<Link>();
    private Set<Link> serviceProvider = new HashSet<Link>();
    private String shortTitle;
    private Set<Link> external = new HashSet<Link>();
    private Set<Link> trace = new HashSet<Link>();
    private Set<Link> refine = new HashSet<Link>();
    private Set<Link> derives = new HashSet<Link>();
    private Set<Link> elaborates = new HashSet<Link>();
    private Set<Link> satisfy = new HashSet<Link>();

    public Resource() {
    }

    public Resource(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"resource", Resource.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        String result = "";
        result = asLocalResource ? result + "{a Local Resource Resource} - update Resource.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addContributor(Link contributor) {
        this.contributor.add(contributor);
    }

    @Override
    public void addCreator(Link creator) {
        this.creator.add(creator);
    }

    @Override
    public void addType(String type) {
        this.type.add(type);
    }

    @Override
    public void addInstanceShape(Link instanceShape) {
        this.instanceShape.add(instanceShape);
    }

    @Override
    public void addServiceProvider(Link serviceProvider) {
        this.serviceProvider.add(serviceProvider);
    }

    @Override
    public void addExternal(Link external) {
        this.external.add(external);
    }

    @Override
    public void addTrace(Link trace) {
        this.trace.add(trace);
    }

    @Override
    public void addRefine(Link refine) {
        this.refine.add(refine);
    }

    @Override
    public void addDerives(Link derives) {
        this.derives.add(derives);
    }

    @Override
    public void addElaborates(Link elaborates) {
        this.elaborates.add(elaborates);
    }

    @Override
    public void addSatisfy(Link satisfy) {
        this.satisfy.add(satisfy);
    }

    @Override
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor() {
        return this.contributor;
    }

    @Override
    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated() {
        return this.created;
    }

    @Override
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator() {
        return this.creator;
    }

    @Override
    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcDescription(value="Descriptive text about resource represented as rich text in XHTML content. SHOULD include only content that is valid and suitable inside an XHTML <div> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription() {
        return this.description;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified() {
        return this.modified;
    }

    @Override
    @OslcName(value="source")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/source")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcReadOnly(value=false)
    public URI getSource() {
        return this.source;
    }

    @Override
    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle() {
        return this.title;
    }

    @Override
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/type")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public Set<String> getType() {
        return this.type;
    }

    @Override
    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape() {
        return this.instanceShape;
    }

    @Override
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    @OslcName(value="shortTitle")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcDescription(value="Shorter form of dcterms:title for the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getShortTitle() {
        return this.shortTitle;
    }

    @Override
    @OslcName(value="external")
    @OslcPropertyDefinition(value="http://jazz.net/ns/dm/linktypes#external")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    @OslcTitle(value="external")
    public Set<Link> getExternal() {
        return this.external;
    }

    @Override
    @OslcName(value="trace")
    @OslcPropertyDefinition(value="http://jazz.net/ns/dm/linktypes#trace")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    @OslcTitle(value="trace")
    public Set<Link> getTrace() {
        return this.trace;
    }

    @Override
    @OslcName(value="refine")
    @OslcPropertyDefinition(value="http://jazz.net/ns/dm/linktypes#refine")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    @OslcTitle(value="refine")
    public Set<Link> getRefine() {
        return this.refine;
    }

    @Override
    @OslcName(value="derives")
    @OslcPropertyDefinition(value="http://jazz.net/ns/dm/linktypes#derives")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    @OslcTitle(value="derives")
    public Set<Link> getDerives() {
        return this.derives;
    }

    @Override
    @OslcName(value="elaborates")
    @OslcPropertyDefinition(value="http://jazz.net/ns/dm/linktypes#elaborates")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    @OslcTitle(value="elaborates")
    public Set<Link> getElaborates() {
        return this.elaborates;
    }

    @Override
    @OslcName(value="satisfy")
    @OslcPropertyDefinition(value="http://jazz.net/ns/dm/linktypes#satisfy")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    @OslcTitle(value="satisfy")
    public Set<Link> getSatisfy() {
        return this.satisfy;
    }

    @Override
    public void setContributor(Set<Link> contributor) {
        this.contributor.clear();
        if (contributor != null) {
            this.contributor.addAll(contributor);
        }
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public void setCreator(Set<Link> creator) {
        this.creator.clear();
        if (creator != null) {
            this.creator.addAll(creator);
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public void setSource(URI source) {
        this.source = source;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setType(Set<String> type) {
        this.type.clear();
        if (type != null) {
            this.type.addAll(type);
        }
    }

    @Override
    public void setInstanceShape(Set<Link> instanceShape) {
        this.instanceShape.clear();
        if (instanceShape != null) {
            this.instanceShape.addAll(instanceShape);
        }
    }

    @Override
    public void setServiceProvider(Set<Link> serviceProvider) {
        this.serviceProvider.clear();
        if (serviceProvider != null) {
            this.serviceProvider.addAll(serviceProvider);
        }
    }

    @Override
    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    @Override
    public void setExternal(Set<Link> external) {
        this.external.clear();
        if (external != null) {
            this.external.addAll(external);
        }
    }

    @Override
    public void setTrace(Set<Link> trace) {
        this.trace.clear();
        if (trace != null) {
            this.trace.addAll(trace);
        }
    }

    @Override
    public void setRefine(Set<Link> refine) {
        this.refine.clear();
        if (refine != null) {
            this.refine.addAll(refine);
        }
    }

    @Override
    public void setDerives(Set<Link> derives) {
        this.derives.clear();
        if (derives != null) {
            this.derives.addAll(derives);
        }
    }

    @Override
    public void setElaborates(Set<Link> elaborates) {
        this.elaborates.clear();
        if (elaborates != null) {
            this.elaborates.addAll(elaborates);
        }
    }

    @Override
    public void setSatisfy(Set<Link> satisfy) {
        this.satisfy.clear();
        if (satisfy != null) {
            this.satisfy.addAll(satisfy);
        }
    }
}

