/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.am;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.am.ILinkType;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/am#")
@OslcName(value="LinkType")
@OslcResourceShape(title="LinkType Resource Shape", describes={"http://open-services.net/ns/am#LinkType"})
public class LinkType
extends AbstractResource
implements ILinkType {
    private Set<Link> contributor = new HashSet<Link>();
    private Date created;
    private Set<Link> creator = new HashSet<Link>();
    private String identifier;
    private Date modified;
    private Set<Link> instanceShape = new HashSet<Link>();
    private Set<Link> serviceProvider = new HashSet<Link>();
    private String comment;
    private String label;

    public LinkType() {
    }

    public LinkType(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"linkType", LinkType.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        String result = "";
        result = asLocalResource ? result + "{a Local LinkType Resource} - update LinkType.toString() to present resource as desired." : String.valueOf(this.getAbout());
        result = String.format("%s (LinkType; id=%s)", this.getLabel(), this.getIdentifier());
        return result;
    }

    @Override
    public void addContributor(Link contributor) {
        this.contributor.add(contributor);
    }

    @Override
    public void addCreator(Link creator) {
        this.creator.add(creator);
    }

    @Override
    public void addInstanceShape(Link instanceShape) {
        this.instanceShape.add(instanceShape);
    }

    @Override
    public void addServiceProvider(Link serviceProvider) {
        this.serviceProvider.add(serviceProvider);
    }

    @Override
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor() {
        return this.contributor;
    }

    @Override
    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated() {
        return this.created;
    }

    @Override
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator() {
        return this.creator;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified() {
        return this.modified;
    }

    @Override
    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape() {
        return this.instanceShape;
    }

    @Override
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    @OslcName(value="comment")
    @OslcPropertyDefinition(value="http://www.w3.org/2000/01/rdf-schema#comment")
    @OslcDescription(value="May be used to provide a human-readable description of a resource.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getComment() {
        return this.comment;
    }

    @Override
    @OslcName(value="label")
    @OslcPropertyDefinition(value="http://www.w3.org/2000/01/rdf-schema#label")
    @OslcDescription(value="May be used to provide a human-readable version of a resource's name.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setContributor(Set<Link> contributor) {
        this.contributor.clear();
        if (contributor != null) {
            this.contributor.addAll(contributor);
        }
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public void setCreator(Set<Link> creator) {
        this.creator.clear();
        if (creator != null) {
            this.creator.addAll(creator);
        }
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public void setInstanceShape(Set<Link> instanceShape) {
        this.instanceShape.clear();
        if (instanceShape != null) {
            this.instanceShape.addAll(instanceShape);
        }
    }

    @Override
    public void setServiceProvider(Set<Link> serviceProvider) {
        this.serviceProvider.clear();
        if (serviceProvider != null) {
            this.serviceProvider.addAll(serviceProvider);
        }
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }
}

