/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.validation.impl;

import cats.effect.IO;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.IORuntime$;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.RDFBuilder;
import es.weso.rdf.RDFReader;
import es.weso.rdf.jena.RDFAsJenaModel;
import es.weso.schema.RDFReport;
import es.weso.schema.Result;
import es.weso.schema.Schema;
import es.weso.schema.Schemas;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.shacl.ShaclShapeFactory;
import org.eclipse.lyo.shacl.Shape;
import org.eclipse.lyo.shacl.ValidationReport;
import org.eclipse.lyo.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;

public class ShaclExValidatorImpl
implements Validator {
    private static final Option<String> OPTION_NONE = Option.apply(null);
    private static final String TRIGGER_MODE_TARGET_DECLS = "TargetDecls";
    private static final String SHACLEX = "SHACLex";
    private static final Logger log = LoggerFactory.getLogger(ShaclExValidatorImpl.class);
    private static final String EMPTY_MAP = "";
    private static final IORuntime IO_RUNTIME = IORuntime$.MODULE$.global();

    @Override
    public ValidationReport validate(AbstractResource resource) throws OslcCoreApplicationException, URISyntaxException, ParseException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, DatatypeConfigurationException, InstantiationException, SecurityException, NoSuchMethodException {
        Shape shaclShape = ShaclShapeFactory.createShaclShape(resource.getClass());
        Model shapeModel = JenaModelHelper.createJenaModel((Object[])new Object[]{shaclShape});
        Model dataModel = JenaModelHelper.createJenaModel((Object[])new Object[]{resource});
        return this.getValidationResults(dataModel, shapeModel);
    }

    @Override
    public ValidationReport validate(Model dataModel, Model shapeModel) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        return this.getValidationResults(dataModel, shapeModel);
    }

    @Override
    public ValidationReport validate(Model dataModel, Class<? extends AbstractResource> clazz) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException, ParseException, InstantiationException, SecurityException, NoSuchMethodException {
        Shape shaclShape = ShaclShapeFactory.createShaclShape(clazz);
        Model shapeModel = JenaModelHelper.createJenaModel((Object[])new Object[]{shaclShape});
        return this.getValidationResults(dataModel, shapeModel);
    }

    private ValidationReport getValidationResults(Model dataModel, Model shapeModel) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        Model valResultJenaModel = ModelFactory.createDefaultModel();
        if (log.isDebugEnabled()) {
            log.debug("Data model: \n{}", (Object)dataModel.write((OutputStream)System.out, "Turtle"));
            log.debug("Shape model: \n{}", (Object)shapeModel.write((OutputStream)System.out, "Turtle"));
        }
        Result result = this.validateInternal(dataModel, shapeModel);
        RDFReport validationReport = result.validationReport();
        if (log.isDebugEnabled()) {
            log.debug("Validation report: \n{}", (Object)validationReport);
        }
        String turtleReport = this.reportToTurtle(validationReport);
        ByteArrayInputStream in = new ByteArrayInputStream(turtleReport.getBytes(StandardCharsets.UTF_8));
        valResultJenaModel.read((InputStream)in, null, "Turtle");
        return this.populateValidationReport(result);
    }

    private String reportToTurtle(RDFReport validationReport) {
        Model model = ModelFactory.createDefaultModel();
        RDFAsJenaModel rdfAsJenaModel = this.getRdfAsJenaModel(model);
        IO builderIO = validationReport.toRDF((RDFBuilder)rdfAsJenaModel);
        RDFBuilder rdfBuilder = (RDFBuilder)builderIO.unsafeRunSync(IO_RUNTIME);
        IO stringIO = rdfBuilder.serialize("N-Triples", Option.apply(null));
        String turtleReport = (String)stringIO.unsafeRunSync(IO_RUNTIME);
        return turtleReport;
    }

    private RDFAsJenaModel getRdfAsJenaModel(Model model) {
        IO modelIO = RDFAsJenaModel.fromModel((Model)model, (Option)Option.apply(null), (Option)Option.apply(null), (Map)new HashMap(), (Map)new HashMap());
        RDFAsJenaModel rdfAsJenaModel = (RDFAsJenaModel)modelIO.unsafeRunSync(IO_RUNTIME);
        return rdfAsJenaModel;
    }

    private Result validateInternal(Model resourceAsModel, Model shapeAsModel) throws IllegalArgumentException {
        RDFAsJenaModel resourceAsRDFReader = this.getRdfAsJenaModel(resourceAsModel);
        RDFAsJenaModel shapeAsRDFReader = this.getRdfAsJenaModel(shapeAsModel);
        return this.validate(resourceAsRDFReader, shapeAsRDFReader);
    }

    private Result validate(RDFAsJenaModel rdf, Schema schema) {
        PrefixMap nodeMap = (PrefixMap)rdf.getPrefixMap().unsafeRunSync(IO_RUNTIME);
        PrefixMap shapesMap = schema.pm();
        Option rdfOption = Option.apply((Object)rdf);
        return (Result)schema.validate((RDFReader)rdf, TRIGGER_MODE_TARGET_DECLS, EMPTY_MAP, OPTION_NONE, OPTION_NONE, nodeMap, shapesMap, rdfOption).unsafeRunSync(IO_RUNTIME);
    }

    private Result validate(RDFAsJenaModel resourceAsRDFReader, RDFAsJenaModel shapeAsRDFReader) {
        Schema schema = (Schema)Schemas.fromRDF((RDFReader)shapeAsRDFReader, (String)SHACLEX).onError(throwable -> {
            throw new IllegalArgumentException("A given Shape cannot be used to create a correct Schema");
        }).unsafeRunSync(IO_RUNTIME);
        return this.validate(resourceAsRDFReader, schema);
    }

    ValidationReport populateValidationReport(Result result) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        Model valReportJenaModel = ModelFactory.createDefaultModel();
        RDFReport valReport = result.validationReport();
        String valReportAsTurtle = this.reportToTurtle(valReport);
        if (log.isDebugEnabled()) {
            log.debug("Validation report: \n{}", (Object)valReportAsTurtle);
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(valReportAsTurtle.getBytes("UTF-8"));
            valReportJenaModel.read((InputStream)in, null, "Turtle");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.desearializeJenaModelToJavaObject(valReportJenaModel);
    }

    ValidationReport desearializeJenaModelToJavaObject(Model valReportJenaModel) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        Object[] fromJenaModel = JenaModelHelper.fromJenaModel((Model)valReportJenaModel, ValidationReport.class);
        return (ValidationReport)fromJenaModel[0];
    }
}

