/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.validation.impl;

import es.weso.rdf.PrefixMap;
import es.weso.rdf.RDFReader;
import es.weso.rdf.jena.RDFAsJenaModel;
import es.weso.schema.Result;
import es.weso.schema.Schema;
import es.weso.schema.Schemas;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.shacl.ShaclShapeFactory;
import org.eclipse.lyo.shacl.Shape;
import org.eclipse.lyo.shacl.ValidationReport;
import org.eclipse.lyo.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.util.Either;

public class ShaclExValidatorImpl
implements Validator {
    private static final Option<String> OPTION_NONE = Option.apply(null);
    private static final String TRIGGER_MODE_TARGET_DECLS = "TargetDecls";
    private static final String SHACLEX = "SHACLex";
    private static final Logger log = LoggerFactory.getLogger(ShaclExValidatorImpl.class);
    private static final String EMPTY_MAP = "";

    @Override
    public ValidationReport validate(AbstractResource resource) throws OslcCoreApplicationException, URISyntaxException, ParseException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, DatatypeConfigurationException, InstantiationException, SecurityException, NoSuchMethodException {
        Shape shaclShape = ShaclShapeFactory.createShaclShape(resource.getClass());
        Model shapeModel = JenaModelHelper.createJenaModel((Object[])new Object[]{shaclShape});
        Model dataModel = JenaModelHelper.createJenaModel((Object[])new Object[]{resource});
        return this.getValidationResults(dataModel, shapeModel);
    }

    @Override
    public ValidationReport validate(Model dataModel, Model shapeModel) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        return this.getValidationResults(dataModel, shapeModel);
    }

    @Override
    public ValidationReport validate(Model dataModel, Class<? extends AbstractResource> clazz) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException, ParseException, InstantiationException, SecurityException, NoSuchMethodException {
        Shape shaclShape = ShaclShapeFactory.createShaclShape(clazz);
        Model shapeModel = JenaModelHelper.createJenaModel((Object[])new Object[]{shaclShape});
        return this.getValidationResults(dataModel, shapeModel);
    }

    private ValidationReport getValidationResults(Model dataModel, Model shapeModel) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        Model valResultJenaModel = ModelFactory.createDefaultModel();
        if (log.isDebugEnabled()) {
            log.debug("Data model: \n{}", (Object)dataModel.write((OutputStream)System.out, "Turtle"));
            log.debug("Shape model: \n{}", (Object)shapeModel.write((OutputStream)System.out, "Turtle"));
        }
        Result result = this.validateInternal(dataModel, shapeModel);
        RDFReader valReport = (RDFReader)result.validationReport().right().get();
        Either valReportAsTurtle = valReport.serialize("Turtle");
        if (log.isDebugEnabled()) {
            log.debug("Validation report: \n{}", valReportAsTurtle.right().get());
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(((String)valReportAsTurtle.right().get()).getBytes("UTF-8"));
            valResultJenaModel.read((InputStream)in, null, "Turtle");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.populateValidationReport(result);
    }

    private Result validateInternal(Model resourceAsModel, Model shapeAsModel) throws IllegalArgumentException {
        RDFAsJenaModel resourceAsRDFReader = new RDFAsJenaModel(resourceAsModel);
        RDFAsJenaModel shapeAsRDFReader = new RDFAsJenaModel(shapeAsModel);
        return this.validate(resourceAsRDFReader, shapeAsRDFReader);
    }

    private Result validate(RDFAsJenaModel rdf, Schema schema) {
        PrefixMap nodeMap = rdf.getPrefixMap();
        PrefixMap shapesMap = schema.pm();
        return schema.validate((RDFReader)rdf, TRIGGER_MODE_TARGET_DECLS, EMPTY_MAP, OPTION_NONE, OPTION_NONE, nodeMap, shapesMap);
    }

    private Result validate(RDFAsJenaModel resourceAsRDFReader, RDFAsJenaModel shapeAsRDFReader) {
        Either schemaTry = Schemas.fromRDF((RDFReader)shapeAsRDFReader, (String)SHACLEX);
        if (schemaTry.isRight()) {
            Schema schema = (Schema)schemaTry.right().get();
            return this.validate(resourceAsRDFReader, schema);
        }
        throw new IllegalArgumentException("A given Shape cannot be used to create a correct Schema");
    }

    ValidationReport populateValidationReport(Result result) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        Model valReportJenaModel = ModelFactory.createDefaultModel();
        RDFReader valReport = (RDFReader)result.validationReport().right().get();
        Either valReportAsTurtle = valReport.serialize("Turtle");
        if (log.isDebugEnabled()) {
            log.debug("Validation report: \n{}", valReportAsTurtle.right().get());
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(((String)valReportAsTurtle.right().get()).getBytes("UTF-8"));
            valReportJenaModel.read((InputStream)in, null, "Turtle");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.desearializeJenaModelToJavaObject(valReportJenaModel);
    }

    ValidationReport desearializeJenaModelToJavaObject(Model valReportJenaModel) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        Object[] fromJenaModel = JenaModelHelper.fromJenaModel((Model)valReportJenaModel, ValidationReport.class);
        return (ValidationReport)fromJenaModel[0];
    }
}

