/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@Deprecated
@OslcNamespace(value="http://open-services.net/ns/cm#")
@OslcResourceShape(title="Change Request Resource Shape", describes={"http://open-services.net/ns/cm#ChangeRequest"})
public class ChangeRequest
extends AbstractResource {
    private final Set<Link> affectedByDefects = new HashSet<Link>();
    private final Set<Link> affectsPlanItems = new HashSet<Link>();
    private final Set<Link> affectsRequirements = new HashSet<Link>();
    private final Set<Link> affectsTestResults = new HashSet<Link>();
    private final Set<Link> blocksTestExecutionRecords = new HashSet<Link>();
    private final Set<URI> contributors = new TreeSet<URI>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<String> dctermsTypes = new TreeSet<String>();
    private final Set<Link> implementsRequirements = new HashSet<Link>();
    private final Set<Link> relatedChangeRequests = new HashSet<Link>();
    private final Set<Link> relatedResources = new HashSet<Link>();
    private final Set<Link> relatedTestCases = new HashSet<Link>();
    private final Set<Link> relatedTestExecutionRecords = new HashSet<Link>();
    private final Set<Link> relatedTestPlans = new HashSet<Link>();
    private final Set<Link> relatedTestScripts = new HashSet<Link>();
    private final Set<String> subjects = new TreeSet<String>();
    private final Set<Link> testedByTestCases = new HashSet<Link>();
    private final Set<Link> tracksChangeSets = new HashSet<Link>();
    private final Set<Link> tracksRequirements = new HashSet<Link>();
    private final Set<URI> rdfTypes = new TreeSet<URI>();
    private Boolean approved;
    private Boolean closed;
    private Date closeDate;
    private Date created;
    private String description;
    private URI discussedBy;
    private Boolean fixed;
    private String identifier;
    private Boolean inProgress;
    private URI instanceShape;
    private Date modified;
    private Boolean reviewed;
    private URI serviceProvider;
    private String shortTitle;
    private String status;
    private String title;
    private Boolean verified;

    public ChangeRequest() throws URISyntaxException {
        this.rdfTypes.add(new URI("http://open-services.net/ns/cm#ChangeRequest"));
    }

    public ChangeRequest(URI about) throws URISyntaxException {
        super(about);
        this.rdfTypes.add(new URI("http://open-services.net/ns/cm#ChangeRequest"));
    }

    public void addAffectedByDefect(Link affectedByDefect) {
        this.affectedByDefects.add(affectedByDefect);
    }

    public void addAffectsPlanItem(Link affectsPlanItem) {
        this.affectsPlanItems.add(affectsPlanItem);
    }

    public void addAffectsRequirement(Link affectsRequirement) {
        this.affectsRequirements.add(affectsRequirement);
    }

    public void addAffectsTestResult(Link affectsTestResult) {
        this.affectsTestResults.add(affectsTestResult);
    }

    public void addBlocksTestExecutionRecord(Link blocksTestExecutionRecord) {
        this.blocksTestExecutionRecords.add(blocksTestExecutionRecord);
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addDctermsType(String dctermsType) {
        this.dctermsTypes.add(dctermsType);
    }

    public void addImplementsRequirement(Link implementsRequirement) {
        this.implementsRequirements.add(implementsRequirement);
    }

    public void addRdfType(URI rdfType) {
        this.rdfTypes.add(rdfType);
    }

    public void addRelatedChangeRequest(Link relatedChangeRequest) {
        this.relatedChangeRequests.add(relatedChangeRequest);
    }

    public void addRelatedResource(Link relatedResource) {
        this.relatedResources.add(relatedResource);
    }

    public void addRelatedTestCase(Link relatedTestCase) {
        this.relatedTestCases.add(relatedTestCase);
    }

    public void addRelatedTestExecutionRecord(Link relatedTestExecutionRecord) {
        this.relatedTestExecutionRecords.add(relatedTestExecutionRecord);
    }

    public void addRelatedTestPlan(Link relatedTestPlan) {
        this.relatedTestPlans.add(relatedTestPlan);
    }

    public void addRelatedTestScript(Link relatedTestScript) {
        this.relatedTestScripts.add(relatedTestScript);
    }

    public void addSubject(String subject) {
        this.subjects.add(subject);
    }

    public void addTestedByTestCase(Link testedByTestCase) {
        this.testedByTestCases.add(testedByTestCase);
    }

    public void addTracksChangeSet(Link tracksChangeSet) {
        this.tracksChangeSets.add(tracksChangeSet);
    }

    public void addTracksRequirement(Link tracksRequirement) {
        this.tracksRequirements.add(tracksRequirement);
    }

    @OslcDescription(value="Change request is affected by a reported defect.")
    @OslcName(value="affectedByDefect")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectedByDefect")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Affected By Defects")
    public Link[] getAffectedByDefects() {
        return this.affectedByDefects.toArray(new Link[this.affectedByDefects.size()]);
    }

    @OslcDescription(value="Change request affects a plan item. ")
    @OslcName(value="affectsPlanItem")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectsPlanItem")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Affects Plan Items")
    public Link[] getAffectsPlanItems() {
        return this.affectsPlanItems.toArray(new Link[this.affectsPlanItems.size()]);
    }

    @OslcDescription(value="Change request affecting a Requirement.")
    @OslcName(value="affectsRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectsRequirement")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Affects Requirements")
    public Link[] getAffectsRequirements() {
        return this.affectsRequirements.toArray(new Link[this.affectsRequirements.size()]);
    }

    @OslcDescription(value="Associated QM resource that is affected by this Change Request.")
    @OslcName(value="affectsTestResult")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectsTestResult")
    @OslcRange(value={"http://open-services.net/ns/qm#TestResult"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Affects Test Results")
    public Link[] getAffectsTestResults() {
        return this.affectsTestResults.toArray(new Link[this.affectsTestResults.size()]);
    }

    @OslcDescription(value="Associated QM resource that is blocked by this Change Request.")
    @OslcName(value="blocksTestExecutionRecord")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#blocksTestExecutionRecord")
    @OslcRange(value={"http://open-services.net/ns/qm#TestExecutionRecord"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Blocks Test Execution Records")
    public Link[] getBlocksTestExecutionRecords() {
        return this.blocksTestExecutionRecords.toArray(new Link[this.blocksTestExecutionRecords.size()]);
    }

    @OslcDescription(value="The date at which no further activity or work is intended to be conducted. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#closeDate")
    @OslcReadOnly
    @OslcTitle(value="Close Date")
    public Date getCloseDate() {
        return this.closeDate;
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the change request.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Timestamp of resource creation.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcReadOnly
    @OslcTitle(value="Created")
    public Date getCreated() {
        return this.created;
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcAllowedValue(value={"Defect", "Task", "Story", "Bug Report", "Feature Request"})
    @OslcDescription(value="A short string representation for the type, example 'Defect'.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/type")
    @OslcTitle(value="Types")
    public String[] getDctermsTypes() {
        return this.dctermsTypes.toArray(new String[this.dctermsTypes.size()]);
    }

    @OslcDescription(value="Descriptive text (reference: Dublin Core) about resource represented as rich text in XHTML content.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="A series of notes and comments about this change request.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#discussedBy")
    @OslcRange(value={"http://open-services.net/ns/core#Discussion"})
    @OslcTitle(value="Discussed By")
    public URI getDiscussedBy() {
        return this.discussedBy;
    }

    @OslcDescription(value="A unique identifier for a resource. Assigned by the service provider when a resource is created. Not intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcReadOnly
    @OslcTitle(value="Identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @OslcDescription(value="Implements associated Requirement.")
    @OslcName(value="implementsRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#implementsRequirement")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Implements Requirements")
    public Link[] getImplementsRequirements() {
        return this.implementsRequirements.toArray(new Link[this.implementsRequirements.size()]);
    }

    @OslcDescription(value="Resource Shape that provides hints as to resource property value-types and allowed values. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcTitle(value="Instance Shape")
    public URI getInstanceShape() {
        return this.instanceShape;
    }

    @OslcDescription(value="Timestamp last latest resource modification.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcReadOnly
    @OslcTitle(value="Modified")
    public Date getModified() {
        return this.modified;
    }

    @OslcDescription(value="The resource type URIs.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcTitle(value="Types")
    public URI[] getRdfTypes() {
        return this.rdfTypes.toArray(new URI[this.rdfTypes.size()]);
    }

    @OslcDescription(value="This relationship is loosely coupled and has no specific meaning.")
    @OslcName(value="relatedChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#relatedChangeRequest")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Related Change Requests")
    public Link[] getRelatedChangeRequests() {
        return this.relatedChangeRequests.toArray(new Link[this.relatedChangeRequests.size()]);
    }

    @OslcDescription(value="Related OSLC resources of any type.")
    @OslcName(value="relatedResource")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#relatedResource")
    @OslcTitle(value="Related Resources")
    public Link[] getRelatedResources() {
        return this.relatedResources.toArray(new Link[this.relatedResources.size()]);
    }

    @OslcDescription(value="Related QM test case resource.")
    @OslcName(value="relatedTestCase")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#relatedTestCase")
    @OslcRange(value={"http://open-services.net/ns/qm#TestCase"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Related Test Cases")
    public Link[] getRelatedTestCases() {
        return this.relatedTestCases.toArray(new Link[this.relatedTestCases.size()]);
    }

    @OslcDescription(value="Related to a QM test execution resource.")
    @OslcName(value="relatedTestExecutionRecord")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#relatedTestExecutionRecord")
    @OslcRange(value={"http://open-services.net/ns/qm#TestExecutionRecord"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Related Test Execution Records")
    public Link[] getRelatedTestExecutionRecords() {
        return this.relatedTestExecutionRecords.toArray(new Link[this.relatedTestExecutionRecords.size()]);
    }

    @OslcDescription(value="Related QM test plan resource.")
    @OslcName(value="relatedTestPlan")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#relatedTestPlan")
    @OslcRange(value={"http://open-services.net/ns/qm#TestPlan"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Related Test Plans")
    public Link[] getRelatedTestPlans() {
        return this.relatedTestPlans.toArray(new Link[this.relatedTestPlans.size()]);
    }

    @OslcDescription(value="Related QM test script resource.")
    @OslcName(value="relatedTestScript")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#relatedTestScript")
    @OslcRange(value={"http://open-services.net/ns/qm#TestScript"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Related Test Scripts")
    public Link[] getRelatedTestScripts() {
        return this.relatedTestScripts.toArray(new Link[this.relatedTestScripts.size()]);
    }

    @OslcDescription(value="The scope of a resource is a URI for the resource's OSLC Service Provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    @OslcTitle(value="Service Provider")
    public URI getServiceProvider() {
        return this.serviceProvider;
    }

    @OslcDescription(value="Short name identifying a resource, often used as an abbreviated identifier for presentation to end-users.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcTitle(value="Short Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getShortTitle() {
        return this.shortTitle;
    }

    @OslcDescription(value="Used to indicate the status of the change request based on values defined by the service provider. Most often a read-only property. Some possible values may include: 'Submitted', 'Done', 'InProgress', etc.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#status")
    @OslcTitle(value="Status")
    public String getStatus() {
        return this.status;
    }

    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcReadOnly(value=false)
    @OslcTitle(value="Subjects")
    public String[] getSubjects() {
        return this.subjects.toArray(new String[this.subjects.size()]);
    }

    @OslcDescription(value="Test case by which this change request is tested.")
    @OslcName(value="testedByTestCase")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#testedByTestCase")
    @OslcRange(value={"http://open-services.net/ns/qm#TestCase"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Tested by Test Cases")
    public Link[] getTestedByTestCases() {
        return this.testedByTestCases.toArray(new Link[this.testedByTestCases.size()]);
    }

    @OslcDescription(value="Title (reference: Dublin Core) or often a single line summary of the resource represented as rich text in XHTML content.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    @OslcDescription(value="Tracks SCM change set resource.")
    @OslcName(value="tracksChangeSet")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#tracksChangeSet")
    @OslcRange(value={"http://open-services.net/ns/scm#ChangeSet"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Tracks Change Sets")
    public Link[] getTracksChangeSets() {
        return this.tracksChangeSets.toArray(new Link[this.tracksChangeSets.size()]);
    }

    @OslcDescription(value="Tracks the associated Requirement or Requirement ChangeSet resources.")
    @OslcName(value="tracksRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#tracksRequirement")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Tracks Requirements")
    public Link[] getTracksRequirements() {
        return this.tracksRequirements.toArray(new Link[this.tracksRequirements.size()]);
    }

    @OslcDescription(value="Whether or not the Change Request has been approved.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#approved")
    @OslcReadOnly
    @OslcTitle(value="Approved")
    public Boolean isApproved() {
        return this.approved;
    }

    @OslcDescription(value="Whether or not the Change Request is completely done, no further fixes or fix verification is needed.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#closed")
    @OslcReadOnly
    @OslcTitle(value="Closed")
    public Boolean isClosed() {
        return this.closed;
    }

    @OslcDescription(value="Whether or not the Change Request has been fixed.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#fixed")
    @OslcReadOnly
    @OslcTitle(value="Fixed")
    public Boolean isFixed() {
        return this.fixed;
    }

    @OslcDescription(value="Whether or not the Change Request in a state indicating that active work is occurring. If oslc_cm:inprogress is true, then oslc_cm:fixed and oslc_cm:closed must also be false.")
    @OslcName(value="inprogress")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#inprogress")
    @OslcReadOnly
    @OslcTitle(value="In Progress")
    public Boolean isInProgress() {
        return this.inProgress;
    }

    @OslcDescription(value="Whether or not the Change Request has been reviewed.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#reviewed")
    @OslcReadOnly
    @OslcTitle(value="Reviewed")
    public Boolean isReviewed() {
        return this.reviewed;
    }

    @OslcDescription(value="Whether or not the resolution or fix of the Change Request has been verified.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#verified")
    @OslcReadOnly
    @OslcTitle(value="Verified")
    public Boolean isVerified() {
        return this.verified;
    }

    public void setAffectedByDefects(Link[] affectedByDefects) {
        this.affectedByDefects.clear();
        if (affectedByDefects != null) {
            this.affectedByDefects.addAll(Arrays.asList(affectedByDefects));
        }
    }

    public void setAffectsPlanItems(Link[] affectsPlanItems) {
        this.affectsPlanItems.clear();
        if (affectsPlanItems != null) {
            this.affectsPlanItems.addAll(Arrays.asList(affectsPlanItems));
        }
    }

    public void setAffectsRequirements(Link[] affectsRequirements) {
        this.affectsRequirements.clear();
        if (affectsRequirements != null) {
            this.affectsRequirements.addAll(Arrays.asList(affectsRequirements));
        }
    }

    public void setAffectsTestResults(Link[] affectsTestResults) {
        this.affectsTestResults.clear();
        if (affectsTestResults != null) {
            this.affectsTestResults.addAll(Arrays.asList(affectsTestResults));
        }
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public void setBlocksTestExecutionRecords(Link[] blocksTestExecutionRecords) {
        this.blocksTestExecutionRecords.clear();
        if (blocksTestExecutionRecords != null) {
            this.blocksTestExecutionRecords.addAll(Arrays.asList(blocksTestExecutionRecords));
        }
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setDctermsTypes(String[] dctermsTypes) {
        this.dctermsTypes.clear();
        if (dctermsTypes != null) {
            this.dctermsTypes.addAll(Arrays.asList(dctermsTypes));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDiscussedBy(URI discussedBy) {
        this.discussedBy = discussedBy;
    }

    public void setFixed(Boolean fixed) {
        this.fixed = fixed;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setImplementsRequirements(Link[] implementsRequirements) {
        this.implementsRequirements.clear();
        if (implementsRequirements != null) {
            this.implementsRequirements.addAll(Arrays.asList(implementsRequirements));
        }
    }

    public void setInProgress(Boolean inProgress) {
        this.inProgress = inProgress;
    }

    public void setInstanceShape(URI instanceShape) {
        this.instanceShape = instanceShape;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setRdfTypes(URI[] rdfTypes) {
        this.rdfTypes.clear();
        if (rdfTypes != null) {
            this.rdfTypes.addAll(Arrays.asList(rdfTypes));
        }
    }

    public void setRelatedChangeRequests(Link[] relatedChangeRequests) {
        this.relatedChangeRequests.clear();
        if (relatedChangeRequests != null) {
            this.relatedChangeRequests.addAll(Arrays.asList(relatedChangeRequests));
        }
    }

    public void setRelatedResources(Link[] relatedResources) {
        this.relatedResources.clear();
        if (relatedResources != null) {
            this.relatedResources.addAll(Arrays.asList(relatedResources));
        }
    }

    public void setRelatedTestCases(Link[] relatedTestCases) {
        this.relatedTestCases.clear();
        if (relatedTestCases != null) {
            this.relatedTestCases.addAll(Arrays.asList(relatedTestCases));
        }
    }

    public void setRelatedTestExecutionRecords(Link[] relatedTestExecutionRecords) {
        this.relatedTestExecutionRecords.clear();
        if (relatedTestExecutionRecords != null) {
            this.relatedTestExecutionRecords.addAll(Arrays.asList(relatedTestExecutionRecords));
        }
    }

    public void setRelatedTestPlans(Link[] relatedTestPlans) {
        this.relatedTestPlans.clear();
        if (relatedTestPlans != null) {
            this.relatedTestPlans.addAll(Arrays.asList(relatedTestPlans));
        }
    }

    public void setRelatedTestScripts(Link[] relatedTestScripts) {
        this.relatedTestScripts.clear();
        if (relatedTestScripts != null) {
            this.relatedTestScripts.addAll(Arrays.asList(relatedTestScripts));
        }
    }

    public void setReviewed(Boolean reviewed) {
        this.reviewed = reviewed;
    }

    public void setServiceProvider(URI serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSubjects(String[] subjects) {
        this.subjects.clear();
        if (subjects != null) {
            this.subjects.addAll(Arrays.asList(subjects));
        }
    }

    public void setTestedByTestCases(Link[] testedByTestCases) {
        this.testedByTestCases.clear();
        if (testedByTestCases != null) {
            this.testedByTestCases.addAll(Arrays.asList(testedByTestCases));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTracksChangeSets(Link[] tracksChangeSets) {
        this.tracksChangeSets.clear();
        if (tracksChangeSets != null) {
            this.tracksChangeSets.addAll(Arrays.asList(tracksChangeSets));
        }
    }

    public void setTracksRequirements(Link[] tracksRequirements) {
        this.tracksRequirements.clear();
        if (tracksRequirements != null) {
            this.tracksRequirements.addAll(Arrays.asList(tracksRequirements));
        }
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }
}

