/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.query;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lyo.client.query.OslcQuery;

public class OslcQueryParameters {
    private String where;
    private String select;
    private String searchTerms;
    private String orderBy;
    private String prefix;
    private String configurationContext;
    private static final Logger logger = Logger.getLogger(OslcQuery.class.getName());

    public OslcQueryParameters() {
    }

    public OslcQueryParameters(String where, String select, String searchTerms, String orderBy, String prefix) {
        this.where = where;
        this.select = select;
        this.searchTerms = searchTerms;
        this.orderBy = orderBy;
        this.prefix = prefix;
    }

    public OslcQueryParameters(String where, String select, String searchTerms, String orderBy, String prefix, String configurationContext) {
        this.where = where;
        this.select = select;
        this.searchTerms = searchTerms;
        this.orderBy = orderBy;
        this.prefix = prefix;
        this.configurationContext = configurationContext;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(String searchTerms) {
        this.searchTerms = searchTerms;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getConfigurationContext() {
        return this.configurationContext;
    }

    public void setConfigurationContext(String configurationContext) {
        this.configurationContext = configurationContext;
    }

    private String encodeQueryParams(String oslcQueryParam) {
        String encodedQueryParms = null;
        try {
            encodedQueryParms = URLEncoder.encode(oslcQueryParam, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "Could not UTF-8 encode query parameters: " + oslcQueryParam, e);
        }
        return encodedQueryParms;
    }
}

