/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEEFormAuthenticator
implements ClientRequestFilter,
ClientResponseFilter {
    private final Logger log = LoggerFactory.getLogger(JEEFormAuthenticator.class);
    private static final String COOKIE = "Cookie";
    private static final String J_SECURITY_CHECK = "j_security_check";
    private static final String J_USERNAME = "j_username";
    private static final String J_PASSWORD = "j_password";
    private static final String FORM_AUTHENTICATOR_REUSED = "org.eclipse.lyo.client.oslc.JEEFormAuthenticator.reused";
    private static final String JAZZ_AUTH_MESSAGE_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    private static final String JAZZ_AUTH_REQUIRED = "authrequired";
    private static final String JAZZ_AUTH_FAILED = "authfailed";
    private final String userId;
    private final String password;
    private final String baseUri;
    private boolean followingRedirects = false;
    Client authClient = null;
    private final List<Object> cookies = new ArrayList<Object>();

    public JEEFormAuthenticator() {
        this.userId = null;
        this.password = null;
        this.baseUri = null;
    }

    public JEEFormAuthenticator(String baseUri, String username, String password) {
        this.userId = username;
        this.password = password;
        this.baseUri = baseUri;
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) {
        if (this.followingRedirects) {
            return;
        }
        boolean authRequired = JAZZ_AUTH_REQUIRED.equals(response.getHeaderString(JAZZ_AUTH_MESSAGE_HEADER));
        boolean authAlreadyAttempted = this.isAuthAlreadyAttempted(request);
        if (authRequired && authAlreadyAttempted) {
            response.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
            this.log.trace("Jazz auth cookies were appended but the request was UNAUTHORIZED anyway");
            return;
        }
        if (!authRequired) {
            this.log.trace("Response was non-401, skipping the ClientResponseFilter for Jazz Forms auth");
            return;
        }
        this.log.trace("Response is 401, attempting Jazz Forms authentication");
        this.cookies.clear();
        this.authClient = request.getClient();
        Form form = new Form();
        form.param(J_USERNAME, this.userId);
        form.param(J_PASSWORD, this.password);
        Response authResponse = this.authClient.target(this.baseUri).path(J_SECURITY_CHECK).request(new String[]{"application/x-www-form-urlencoded"}).property(FORM_AUTHENTICATOR_REUSED, (Object)"true").header("Accept", (Object)"*/*").header("X-Requested-With", (Object)"XMLHttpRequest").header("OSLC-Core-Version", (Object)"2.0").post(Entity.form((Form)form));
        authResponse.getCookies().values().forEach(cookie -> this.cookies.add(cookie.toCookie()));
        int statusCode = authResponse.getStatus();
        String jazzAuthMessage = authResponse.getHeaderString(JAZZ_AUTH_MESSAGE_HEADER);
        if (jazzAuthMessage != null && jazzAuthMessage.equalsIgnoreCase(JAZZ_AUTH_FAILED)) {
            authResponse.close();
            response.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
            this.log.trace("Jazz Forms authentication failed");
            return;
        }
        String location = authResponse.getHeaderString("Location");
        try {
            authResponse.close();
        }
        catch (ProcessingException e) {
            this.log.warn("Connection not closed cleanly");
        }
        statusCode = this.followRedirects(statusCode, location);
        Client requestClient = request.getClient();
        Invocation.Builder retryBuilder = requestClient.target(request.getUri()).request(new MediaType[]{request.getMediaType()});
        retryBuilder.property(FORM_AUTHENTICATOR_REUSED, (Object)"true");
        MultivaluedHashMap newHeaders = new MultivaluedHashMap();
        newHeaders.putAll((Map)request.getHeaders());
        newHeaders.add((Object)COOKIE, this.cookies);
        retryBuilder.headers((MultivaluedMap)newHeaders);
        String requestMethod = request.getMethod();
        Invocation invocation = request.getEntity() == null ? retryBuilder.build(requestMethod) : retryBuilder.build(requestMethod, Entity.entity((Object)request.getEntity(), (MediaType)request.getMediaType()));
        this.log.trace("Retrying the failed request with Jazz cookies");
        Response retryResponse = invocation.invoke();
        if (retryResponse.hasEntity()) {
            response.setEntityStream((InputStream)retryResponse.readEntity(InputStream.class));
        }
        MultivaluedMap headers = response.getHeaders();
        headers.clear();
        headers.putAll((Map)retryResponse.getStringHeaders());
        response.setStatus(retryResponse.getStatus());
    }

    private boolean isAuthAlreadyAttempted(ClientRequestContext request) {
        return "true".equals(request.getProperty(FORM_AUTHENTICATOR_REUSED));
    }

    private int followRedirects(int statusCode, String location) {
        this.followingRedirects = true;
        while (location != null && statusCode >= 301 && statusCode <= 399) {
            Response lastRedirectResponse = this.authClient.target(location).request().get();
            statusCode = lastRedirectResponse.getStatus();
            location = lastRedirectResponse.getHeaderString("Location");
            try {
                lastRedirectResponse.close();
            }
            catch (ProcessingException e) {
                this.log.warn("Last redirect connection not closed cleanly");
            }
        }
        this.followingRedirects = false;
        return statusCode;
    }

    public void filter(ClientRequestContext requestContext) {
        if (this.cookies.size() > 0) {
            requestContext.getHeaders().add((Object)COOKIE, this.cookies);
            this.log.trace("Jazz auth cookies appended to the request");
        } else {
            this.log.trace("Not appending Jazz auth cookies to the request");
        }
    }
}

