/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class EitherTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (!Either.isEither(type)) {
            return null;
        }
        return new Adapter(gson, typeToken);
    }

    protected static class EitherTypeArgument<T> {
        protected final TypeToken<T> token;
        protected final TypeAdapter<T> adapter;
        protected final Collection<JsonToken> expectedTokens;

        public EitherTypeArgument(Gson gson, Type type) {
            this.token = TypeToken.get((Type)type);
            this.adapter = gson.getAdapter(this.token);
            this.expectedTokens = new ArrayList<JsonToken>();
            for (Type disjoinType : Either.getAllDisjoinTypes(type)) {
                Class rawType = TypeToken.get((Type)disjoinType).getRawType();
                JsonToken expectedToken = this.getExpectedToken(rawType);
                this.expectedTokens.add(expectedToken);
            }
        }

        protected JsonToken getExpectedToken(Class<?> rawType) {
            if (rawType.isArray() || List.class.isAssignableFrom(rawType)) {
                return JsonToken.BEGIN_ARRAY;
            }
            if (Boolean.class.isAssignableFrom(rawType)) {
                return JsonToken.BOOLEAN;
            }
            if (Number.class.isAssignableFrom(rawType) || Enum.class.isAssignableFrom(rawType)) {
                return JsonToken.NUMBER;
            }
            if (Character.class.isAssignableFrom(rawType) || String.class.isAssignableFrom(rawType)) {
                return JsonToken.STRING;
            }
            return JsonToken.BEGIN_OBJECT;
        }

        public boolean isAssignable(JsonToken token) {
            return this.expectedTokens.contains(token);
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.adapter.write(out, value);
        }

        public T read(JsonReader in) throws IOException {
            return (T)this.adapter.read(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (JsonToken expectedToken : this.expectedTokens) {
                if (builder.length() != 0) {
                    builder.append(" | ");
                }
                builder.append(expectedToken);
            }
            return builder.toString();
        }
    }

    protected static class Adapter<L, R>
    extends TypeAdapter<Either<L, R>> {
        protected final EitherTypeArgument<L> left;
        protected final EitherTypeArgument<R> right;

        public Adapter(Gson gson, TypeToken<Either<L, R>> typeToken) {
            Type left = Either.getLeftDisjointType(typeToken.getType());
            Type right = Either.getRightDisjointType(typeToken.getType());
            this.left = new EitherTypeArgument(gson, left);
            this.right = new EitherTypeArgument(gson, right);
        }

        public void write(JsonWriter out, Either<L, R> value) throws IOException {
            if (value.isLeft()) {
                this.left.write(out, value.getLeft());
            } else {
                this.right.write(out, value.getRight());
            }
        }

        public Either<L, R> read(JsonReader in) throws IOException {
            JsonToken next = in.peek();
            if (next == JsonToken.NULL) {
                return null;
            }
            if (this.left.isAssignable(next)) {
                return Either.forLeft(this.left.read(in));
            }
            if (this.right.isAssignable(next)) {
                return Either.forRight(this.right.read(in));
            }
            throw new IOException("Unexpected token " + next + ", expected " + this.left + " | " + this.right + " tokens.");
        }
    }
}

