/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import com.google.common.util.concurrent.ForwardingFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageProducer;

public class ConcurrentMessageProcessor
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ConcurrentMessageProcessor.class.getName());
    private boolean isRunning;
    private final MessageProducer messageProducer;
    private final MessageConsumer messageConsumer;

    public static Future<?> startProcessing(final MessageProducer messageProducer, MessageConsumer messageConsumer, ExecutorService executorService) {
        ConcurrentMessageProcessor reader = new ConcurrentMessageProcessor(messageProducer, messageConsumer);
        final Future<?> result = executorService.submit(reader);
        return new ForwardingFuture<Object>(){

            protected Future<Object> delegate() {
                return result;
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                if (mayInterruptIfRunning && messageProducer instanceof Closeable) {
                    try {
                        ((Closeable)((Object)messageProducer)).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
    }

    public ConcurrentMessageProcessor(MessageProducer messageProducer, MessageConsumer messageConsumer) {
        this.messageProducer = messageProducer;
        this.messageConsumer = messageConsumer;
    }

    @Override
    public void run() {
        if (this.isRunning) {
            throw new IllegalStateException("The reader is already running.");
        }
        this.isRunning = true;
        try {
            this.messageProducer.listen(this.messageConsumer);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.isRunning = false;
        }
    }
}

