/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.server.pathmap.PathMappings;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class WebSocketUpgradeHandlerWrapper
extends HandlerWrapper
implements MappedWebSocketCreator {
    private NativeWebSocketConfiguration configuration;

    public WebSocketUpgradeHandlerWrapper() {
        this((ByteBufferPool)new MappedByteBufferPool());
    }

    public WebSocketUpgradeHandlerWrapper(ByteBufferPool bufferPool) {
        this.configuration = new NativeWebSocketConfiguration(new WebSocketServerFactory(bufferPool));
    }

    @Override
    public void addMapping(org.eclipse.jetty.http.pathmap.PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    @Deprecated
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public PathMappings<WebSocketCreator> getMappings() {
        throw new IllegalStateException("Access to PathMappings cannot be supported. See alternative API in javadoc for " + MappedWebSocketCreator.class.getName());
    }

    @Override
    public MappedResource<WebSocketCreator> getMapping(String target) {
        return this.configuration.getMatch(target);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.configuration.getFactory().isUpgradeRequest(request, response)) {
            MappedResource<WebSocketCreator> resource = this.configuration.getMatch(target);
            if (resource == null) {
                response.sendError(404, "No websocket endpoint matching path: " + target);
                return;
            }
            WebSocketCreator creator = (WebSocketCreator)resource.getResource();
            request.setAttribute(org.eclipse.jetty.http.pathmap.PathSpec.class.getName(), resource);
            if (this.configuration.getFactory().acceptWebSocket(creator, request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }
}

