/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.eclipse.jetty.websocket.core.api.BaseConnection;
import org.eclipse.jetty.websocket.core.api.Extension;
import org.eclipse.jetty.websocket.core.api.ExtensionRegistry;
import org.eclipse.jetty.websocket.core.api.UpgradeRequest;
import org.eclipse.jetty.websocket.core.api.UpgradeResponse;
import org.eclipse.jetty.websocket.core.api.WebSocketException;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.extensions.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.core.io.IncomingFrames;
import org.eclipse.jetty.websocket.core.io.OutgoingFrames;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;
import org.eclipse.jetty.websocket.core.io.event.EventDriver;
import org.eclipse.jetty.websocket.core.io.event.EventDriverFactory;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;
import org.eclipse.jetty.websocket.server.ServletWebSocketRequest;
import org.eclipse.jetty.websocket.server.ServletWebSocketResponse;
import org.eclipse.jetty.websocket.server.WebSocketCreator;
import org.eclipse.jetty.websocket.server.WebSocketHandshake;
import org.eclipse.jetty.websocket.server.WebSocketServerConnection;
import org.eclipse.jetty.websocket.server.handshake.HandshakeRFC6455;

public class WebSocketServerFactory
extends ContainerLifeCycle
implements WebSocketCreator {
    private static final Logger LOG = Log.getLogger(WebSocketServerFactory.class);
    private final Map<Integer, WebSocketHandshake> handshakes = new HashMap<Integer, WebSocketHandshake>();
    private final Queue<WebSocketSession> sessions;
    private final Scheduler scheduler;
    private final String supportedVersions;
    private final WebSocketPolicy basePolicy;
    private final EventDriverFactory eventDriverFactory;
    private final WebSocketExtensionRegistry extensionRegistry;
    private WebSocketCreator creator;
    private List<Class<?>> registeredSocketClasses;

    public WebSocketServerFactory(WebSocketPolicy policy) {
        this(policy, (ByteBufferPool)new MappedByteBufferPool());
    }

    public WebSocketServerFactory(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.handshakes.put(13, new HandshakeRFC6455());
        this.sessions = new ConcurrentLinkedQueue<WebSocketSession>();
        this.scheduler = new TimerScheduler();
        this.addBean(this.scheduler);
        this.addBean(bufferPool);
        this.registeredSocketClasses = new ArrayList();
        this.basePolicy = policy;
        this.eventDriverFactory = new EventDriverFactory(this.basePolicy);
        this.extensionRegistry = new WebSocketExtensionRegistry(this.basePolicy, bufferPool);
        this.creator = this;
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (int v : this.handshakes.keySet()) {
            versions.add(v);
        }
        Collections.sort(versions, Collections.reverseOrder());
        StringBuilder rv = new StringBuilder();
        Iterator i$ = versions.iterator();
        while (i$.hasNext()) {
            int v = (Integer)i$.next();
            if (rv.length() > 0) {
                rv.append(", ");
            }
            rv.append(v);
        }
        this.supportedVersions = rv.toString();
    }

    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletWebSocketRequest sockreq = new ServletWebSocketRequest(request);
        ServletWebSocketResponse sockresp = new ServletWebSocketResponse(response);
        WebSocketCreator creator = this.getCreator();
        Object websocketPojo = creator.createWebSocket(sockreq, sockresp);
        if (sockresp.isCommitted()) {
            return false;
        }
        if (websocketPojo == null) {
            response.sendError(503);
            return false;
        }
        EventDriver driver = this.eventDriverFactory.wrap(websocketPojo);
        return this.upgrade(sockreq, sockresp, driver);
    }

    protected void closeConnections() {
        for (WebSocketSession session : this.sessions) {
            session.close();
        }
        this.sessions.clear();
    }

    @Override
    public Object createWebSocket(UpgradeRequest req, UpgradeResponse resp) {
        if (this.registeredSocketClasses.size() < 1) {
            throw new WebSocketException("No WebSockets have been registered with the factory.  Cannot use default implementation of WebSocketCreator.");
        }
        if (this.registeredSocketClasses.size() > 1) {
            LOG.warn("You have registered more than 1 websocket object, and are using the default WebSocketCreator! Using first registered websocket.", new Object[0]);
        }
        Class<?> firstClass = this.registeredSocketClasses.get(0);
        try {
            return firstClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WebSocketException("Unable to create instance of " + firstClass, (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        this.closeConnections();
        super.doStop();
    }

    public WebSocketCreator getCreator() {
        return this.creator;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public WebSocketPolicy getPolicy() {
        return this.basePolicy;
    }

    public List<Extension> initExtensions(List<ExtensionConfig> requested) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (ExtensionConfig cfg : requested) {
            Extension extension = this.extensionRegistry.newInstance(cfg);
            if (extension == null) continue;
            LOG.debug("added {}", new Object[]{extension});
            extensions.add(extension);
        }
        LOG.debug("extensions={}", new Object[]{extensions});
        return extensions;
    }

    public boolean isUpgradeRequest(HttpServletRequest request, HttpServletResponse response) {
        String upgrade = request.getHeader("Upgrade");
        if (upgrade == null) {
            return false;
        }
        if (!"websocket".equalsIgnoreCase(upgrade)) {
            LOG.warn("Not a 'Upgrade: WebSocket' (was [Upgrade: " + upgrade + "])", new Object[0]);
            return false;
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            LOG.warn("Not a 'HTTP/1.1' request (was [" + request.getProtocol() + "])", new Object[0]);
            return false;
        }
        return true;
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public void register(Class<?> websocketPojo) {
        this.registeredSocketClasses.add(websocketPojo);
    }

    public boolean sessionClosed(WebSocketSession session) {
        return this.isRunning() && this.sessions.remove(session);
    }

    public boolean sessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", new Object[]{session});
        }
        if (!this.isRunning()) {
            LOG.warn("Factory is not running", new Object[0]);
            return false;
        }
        boolean ret = this.sessions.offer(session);
        session.onConnect();
        return ret;
    }

    public void setCreator(WebSocketCreator creator) {
        this.creator = creator;
    }

    public boolean upgrade(ServletWebSocketRequest request, ServletWebSocketResponse response, EventDriver driver) throws IOException {
        WebSocketHandshake handshaker;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("Not a 'WebSocket: Upgrade' request");
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            throw new IllegalStateException("Not a 'HTTP/1.1' request");
        }
        int version = request.getIntHeader("Sec-WebSocket-Version");
        if (version < 0) {
            version = request.getIntHeader("Sec-WebSocket-Draft");
        }
        if ((handshaker = this.handshakes.get(version)) == null) {
            LOG.warn("Unsupported Websocket version: " + version, new Object[0]);
            response.setHeader("Sec-WebSocket-Version", this.supportedVersions);
            response.sendError(400, "Unsupported websocket version specification");
            return false;
        }
        HttpConnection http = HttpConnection.getCurrentConnection();
        EndPoint endp = http.getEndPoint();
        Executor executor = http.getConnector().getExecutor();
        ByteBufferPool bufferPool = http.getConnector().getByteBufferPool();
        WebSocketServerConnection connection = new WebSocketServerConnection(endp, executor, this.scheduler, driver.getPolicy(), bufferPool, this);
        LOG.debug("HttpConnection: {}", new Object[]{http});
        LOG.debug("AsyncWebSocketConnection: {}", new Object[]{connection});
        WebSocketSession session = new WebSocketSession(driver, (BaseConnection)connection, this.getPolicy(), response.getAcceptedSubProtocol());
        connection.setSession(session);
        List<Extension> extensions = this.initExtensions(request.getExtensions());
        request.setValidExtensions(extensions);
        WebSocketSession incoming = session;
        WebSocketServerConnection outgoing = connection;
        if (extensions != null) {
            connection.getParser().configureFromExtensions(extensions);
            connection.getGenerator().configureFromExtensions(extensions);
            for (Extension ext : extensions) {
                ext.setNextOutgoingFrames((OutgoingFrames)outgoing);
                outgoing = ext;
            }
            Collections.reverse(extensions);
            for (Extension ext : extensions) {
                ext.setNextIncomingFrames((IncomingFrames)incoming);
                incoming = ext;
            }
        }
        session.setOutgoing((OutgoingFrames)outgoing);
        connection.getParser().setIncomingFramesHandler((IncomingFrames)incoming);
        request.setAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", (Object)connection);
        LOG.debug("Handshake Response: {}", new Object[]{handshaker});
        handshaker.doHandshakeResponse(request, response);
        LOG.debug("Websocket upgrade {} {} {} {}", new Object[]{request.getRequestURI(), version, response.getAcceptedSubProtocol(), connection});
        return true;
    }
}

