/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.HttpCookie;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.util.server.internal.ServletUpgradeRequest;

public class JettyServerUpgradeRequest {
    private ServletUpgradeRequest upgradeRequest;

    JettyServerUpgradeRequest(ServletUpgradeRequest request) {
        this.upgradeRequest = request;
    }

    public X509Certificate[] getCertificates() {
        return this.upgradeRequest.getCertificates();
    }

    public List<HttpCookie> getCookies() {
        return this.upgradeRequest.getCookies();
    }

    public List<ExtensionConfig> getExtensions() {
        return this.upgradeRequest.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this.upgradeRequest.getHeader(name);
    }

    public int getHeaderInt(String name) {
        return this.upgradeRequest.getHeaderInt(name);
    }

    public Map<String, List<String>> getHeadersMap() {
        return this.upgradeRequest.getHeadersMap();
    }

    public List<String> getHeaders(String name) {
        return this.upgradeRequest.getHeaders(name);
    }

    public String getHost() {
        return this.upgradeRequest.getHost();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.upgradeRequest.getHttpServletRequest();
    }

    public String getHttpVersion() {
        return this.upgradeRequest.getHttpVersion();
    }

    public Locale getLocale() {
        return this.upgradeRequest.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.upgradeRequest.getLocales();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.upgradeRequest.getLocalSocketAddress();
    }

    public String getMethod() {
        return this.upgradeRequest.getMethod();
    }

    public String getOrigin() {
        return this.upgradeRequest.getOrigin();
    }

    public Map<String, List<String>> getParameterMap() {
        return this.upgradeRequest.getParameterMap();
    }

    public String getProtocolVersion() {
        return this.upgradeRequest.getProtocolVersion();
    }

    public String getQueryString() {
        return this.upgradeRequest.getQueryString();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.upgradeRequest.getRemoteSocketAddress();
    }

    public String getRequestPath() {
        return this.upgradeRequest.getRequestPath();
    }

    public URI getRequestURI() {
        return this.upgradeRequest.getRequestURI();
    }

    public Object getServletAttribute(String name) {
        return this.upgradeRequest.getServletAttribute(name);
    }

    public Map<String, Object> getServletAttributes() {
        return this.upgradeRequest.getServletAttributes();
    }

    public Map<String, List<String>> getServletParameters() {
        return this.upgradeRequest.getServletParameters();
    }

    public HttpSession getSession() {
        return this.upgradeRequest.getSession();
    }

    public List<String> getSubProtocols() {
        return this.upgradeRequest.getSubProtocols();
    }

    public Principal getUserPrincipal() {
        return this.upgradeRequest.getUserPrincipal();
    }

    public boolean hasSubProtocol(String subprotocol) {
        return this.upgradeRequest.hasSubProtocol(subprotocol);
    }

    public boolean isSecure() {
        return this.upgradeRequest.isSecure();
    }

    public boolean isUserInRole(String role) {
        return this.upgradeRequest.isUserInRole(role);
    }

    public void setServletAttribute(String name, Object value) {
        this.upgradeRequest.setServletAttribute(name, value);
    }
}

