/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.impl;

import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.client.impl.DelegatedJettyClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.impl.DelegatedJettyClientUpgradeResponse;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;

public class JettyClientUpgradeRequest
extends ClientUpgradeRequest {
    private final DelegatedJettyClientUpgradeRequest handshakeRequest;
    private final JettyWebSocketFrameHandler frameHandler;

    public JettyClientUpgradeRequest(WebSocketCoreClient coreClient, UpgradeRequest request, URI requestURI, JettyWebSocketFrameHandlerFactory frameHandlerFactory, Object websocketPojo) {
        super(coreClient, requestURI);
        if (request != null) {
            HttpFields.Mutable fields = this.getHeaders();
            request.getHeaders().forEach((arg_0, arg_1) -> ((HttpFields.Mutable)fields).put(arg_0, arg_1));
            List cookies = request.getCookies();
            if (cookies != null) {
                for (HttpCookie cookie : cookies) {
                    fields.add(HttpHeader.COOKIE, cookie.toString());
                }
            }
            this.setSubProtocols(request.getSubProtocols());
            this.setExtensions(request.getExtensions().stream().map(c -> new ExtensionConfig(c.getName(), c.getParameters())).collect(Collectors.toList()));
            if (request.getMethod() != null) {
                this.method(request.getMethod());
            }
            if (request.getHttpVersion() != null) {
                this.version(HttpVersion.fromString((String)request.getHttpVersion()));
            }
        }
        this.handshakeRequest = new DelegatedJettyClientUpgradeRequest(this);
        this.frameHandler = frameHandlerFactory.newJettyFrameHandler(websocketPojo);
    }

    protected void customize(EndPoint endPoint) {
        super.customize(endPoint);
        this.handshakeRequest.configure(endPoint);
    }

    public void upgrade(HttpResponse response, EndPoint endPoint) {
        this.frameHandler.setUpgradeRequest((UpgradeRequest)new DelegatedJettyClientUpgradeRequest(this));
        this.frameHandler.setUpgradeResponse((UpgradeResponse)new DelegatedJettyClientUpgradeResponse(response));
        super.upgrade(response, endPoint);
    }

    public FrameHandler getFrameHandler() {
        return this.frameHandler;
    }
}

