/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.server.internal;

import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.javax.client.internal.JavaxWebSocketClientFrameHandlerFactory;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.javax.server.internal.JavaxServerUpgradeRequest;
import org.eclipse.jetty.websocket.javax.server.internal.PathParamIdentifier;
import org.eclipse.jetty.websocket.util.InvokerUtils;
import org.eclipse.jetty.websocket.util.server.internal.FrameHandlerFactory;
import org.eclipse.jetty.websocket.util.server.internal.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.util.server.internal.ServerUpgradeResponse;

public class JavaxWebSocketServerFrameHandlerFactory
extends JavaxWebSocketClientFrameHandlerFactory
implements FrameHandlerFactory {
    public JavaxWebSocketServerFrameHandlerFactory(JavaxWebSocketContainer container) {
        super(container, (InvokerUtils.ParamIdentifier)new PathParamIdentifier());
    }

    public JavaxWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass, EndpointConfig endpointConfig) {
        if (Endpoint.class.isAssignableFrom(endpointClass)) {
            return this.createEndpointMetadata(endpointConfig);
        }
        ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
        if (anno == null) {
            return super.getMetadata(endpointClass, endpointConfig);
        }
        UriTemplatePathSpec templatePathSpec = new UriTemplatePathSpec(anno.value());
        JavaxWebSocketFrameHandlerMetadata metadata = new JavaxWebSocketFrameHandlerMetadata(endpointConfig);
        metadata.setUriTemplatePathSpec(templatePathSpec);
        return this.discoverJavaxFrameHandlerMetadata(endpointClass, metadata);
    }

    public FrameHandler newFrameHandler(Object websocketPojo, ServerUpgradeRequest upgradeRequest, ServerUpgradeResponse upgradeResponse) {
        return this.newJavaxWebSocketFrameHandler(websocketPojo, new JavaxServerUpgradeRequest(upgradeRequest));
    }
}

