/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketExtension;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandler;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSessionListener;
import org.eclipse.jetty.websocket.javax.common.SessionTracker;
import org.eclipse.jetty.websocket.javax.common.UpgradeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaxWebSocketContainer
extends ContainerLifeCycle
implements WebSocketContainer,
Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketContainer.class);
    private final List<JavaxWebSocketSessionListener> sessionListeners = new ArrayList<JavaxWebSocketSessionListener>();
    protected final SessionTracker sessionTracker = new SessionTracker();
    protected final Configuration.ConfigurationCustomizer defaultCustomizer = new Configuration.ConfigurationCustomizer();
    protected final WebSocketComponents components;

    public JavaxWebSocketContainer(WebSocketComponents components) {
        this.components = components;
        this.addSessionListener(this.sessionTracker);
        this.addBean(this.sessionTracker);
    }

    public abstract Executor getExecutor();

    protected abstract JavaxWebSocketFrameHandlerFactory getFrameHandlerFactory();

    public ByteBufferPool getBufferPool() {
        return this.components.getBufferPool();
    }

    public WebSocketExtensionRegistry getExtensionRegistry() {
        return this.components.getExtensionRegistry();
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.components.getObjectFactory();
    }

    public WebSocketComponents getWebSocketComponents() {
        return this.components;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultCustomizer.getWriteTimeout().toMillis();
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        long max = this.defaultCustomizer.getMaxBinaryMessageSize();
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultCustomizer.getIdleTimeout().toMillis();
    }

    public int getDefaultMaxTextMessageBufferSize() {
        long max = this.defaultCustomizer.getMaxTextMessageSize();
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public void setAsyncSendTimeout(long ms) {
        this.defaultCustomizer.setWriteTimeout(Duration.ofMillis(ms));
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.defaultCustomizer.setMaxBinaryMessageSize((long)max);
    }

    public void setDefaultMaxSessionIdleTimeout(long ms) {
        this.defaultCustomizer.setIdleTimeout(Duration.ofMillis(ms));
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.defaultCustomizer.setMaxTextMessageSize((long)max);
    }

    public Set<Extension> getInstalledExtensions() {
        HashSet<Extension> ret = new HashSet<Extension>();
        for (String name : this.getExtensionRegistry().getAvailableExtensionNames()) {
            ret.add(new JavaxWebSocketExtension(name));
        }
        return ret;
    }

    public Set<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    public JavaxWebSocketFrameHandler newFrameHandler(Object websocketPojo, UpgradeRequest upgradeRequest) {
        return this.getFrameHandlerFactory().newJavaxWebSocketFrameHandler(websocketPojo, upgradeRequest);
    }

    public void addSessionListener(JavaxWebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(JavaxWebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void notifySessionListeners(Consumer<JavaxWebSocketSessionListener> consumer) {
        for (JavaxWebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener {}", (Object)listener, (Object)x);
            }
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{this.defaultCustomizer});
    }
}

