/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.client.internal;

import java.util.Collections;
import java.util.List;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import org.eclipse.jetty.websocket.javax.common.ClientEndpointConfigWrapper;
import org.eclipse.jetty.websocket.util.InvalidWebSocketException;

public class AnnotatedClientEndpointConfig
extends ClientEndpointConfigWrapper {
    public AnnotatedClientEndpointConfig(ClientEndpoint anno) {
        ClientEndpointConfig.Configurator configurator;
        try {
            configurator = (ClientEndpointConfig.Configurator)anno.configurator().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            StringBuilder err = new StringBuilder();
            err.append("Unable to instantiate ClientEndpoint.configurator() of ");
            err.append(anno.configurator().getName());
            err.append(" defined as annotation in ");
            err.append(anno.getClass().getName());
            throw new InvalidWebSocketException(err.toString(), (Throwable)e);
        }
        ClientEndpointConfig build = ClientEndpointConfig.Builder.create().encoders(List.of(anno.encoders())).decoders(List.of(anno.decoders())).preferredSubprotocols(List.of(anno.subprotocols())).extensions(Collections.emptyList()).configurator(configurator).build();
        this.init(build);
    }
}

