/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.client.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.HandshakeResponse;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;

public class JsrUpgradeListener
implements UpgradeListener {
    private ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    public void onHandshakeRequest(HttpRequest request) {
        if (this.configurator == null) {
            return;
        }
        HttpFields fields = request.getHeaders();
        HashMap<String, List> originalHeaders = new HashMap<String, List>();
        fields.forEach(field -> {
            ArrayList values = new ArrayList();
            Stream.of(field.getValues()).forEach(val -> values.add(val));
            originalHeaders.put(field.getName(), values);
        });
        this.configurator.beforeRequest(originalHeaders);
        fields.clear();
        originalHeaders.forEach((name, values) -> fields.put(name, values));
    }

    public void onHandshakeResponse(HttpRequest request, HttpResponse response) {
        if (this.configurator == null) {
            return;
        }
        HandshakeResponse handshakeResponse = () -> {
            HttpFields fields = response.getHeaders();
            HashMap ret = new HashMap();
            fields.forEach(field -> {
                ArrayList values = new ArrayList();
                Stream.of(field.getValues()).forEach(val -> values.add(val));
                ret.put(field.getName(), values);
            });
            return ret;
        };
        this.configurator.afterResponse(handshakeResponse);
    }
}

