/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.messages;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.List;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.jakarta.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.websocket.jakarta.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.util.messages.MessageSink;
import org.eclipse.jetty.websocket.util.messages.StringMessageSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodedTextMessageSink<T>
extends AbstractDecodedMessageSink.Basic<Decoder.Text<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(DecodedTextMessageSink.class);

    public DecodedTextMessageSink(CoreSession session, MethodHandle methodHandle, List<RegisteredDecoder> decoders) {
        super(session, methodHandle, decoders);
    }

    @Override
    MessageSink newMessageSink(CoreSession coreSession) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle methodHandle = JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup().findVirtual(this.getClass(), "onMessage", MethodType.methodType(Void.TYPE, String.class)).bindTo(this);
        return new StringMessageSink(coreSession, methodHandle);
    }

    public void onMessage(String wholeMessage) {
        for (Decoder.Text decoder : this._decoders) {
            if (!decoder.willDecode(wholeMessage)) continue;
            try {
                Object obj = decoder.decode(wholeMessage);
                this.invoke(obj);
                return;
            }
            catch (DecodeException e) {
                throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", (Throwable)e);
            }
        }
        LOG.warn("Message lost, willDecode() has returned false for all decoders in the decoder list.");
    }
}

