/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;

public class FrameDebugExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(FrameDebugExtension.class);
    private static final int BUFSIZE = 32768;
    private Generator generator;
    private Path outputDir;
    private String prefix = "frame";
    private AtomicLong incomingId = new AtomicLong(0L);
    private AtomicLong outgoingId = new AtomicLong(0L);

    @Override
    public String getName() {
        return "@frame-debug";
    }

    public void incomingFrame(Frame frame) {
        this.saveFrame(frame, false);
        this.nextIncomingFrame(frame);
    }

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        this.saveFrame(frame, true);
        this.nextOutgoingFrame(frame, callback, batchMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFrame(Frame frame, boolean outgoing) {
        if (this.outputDir == null || this.generator == null) {
            return;
        }
        StringBuilder filename = new StringBuilder();
        filename.append(this.prefix);
        if (outgoing) {
            filename.append(String.format("-outgoing-%05d", this.outgoingId.getAndIncrement()));
        } else {
            filename.append(String.format("-incoming-%05d", this.incomingId.getAndIncrement()));
        }
        filename.append(".dat");
        Path outputFile = this.outputDir.resolve(filename.toString());
        ByteBuffer buf = this.getBufferPool().acquire(32768, false);
        try (SeekableByteChannel channel = Files.newByteChannel(outputFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.generator.generateHeaderBytes(frame, buf);
            channel.write(buf);
            if (frame.hasPayload()) {
                channel.write(frame.getPayload().slice());
            }
            LOG.debug("Saved raw frame: {}", new Object[]{outputFile.toString()});
        }
        catch (IOException e) {
            LOG.warn("Unable to save frame: " + filename.toString(), (Throwable)e);
        }
        finally {
            this.getBufferPool().release(buf);
        }
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        String cfgPrefix;
        super.setConfig(config);
        String cfgOutputDir = config.getParameter("output-dir", null);
        if (StringUtil.isNotBlank((String)cfgOutputDir)) {
            Path path = new File(cfgOutputDir).toPath();
            if (Files.isDirectory(path, new LinkOption[0]) && Files.exists(path, new LinkOption[0]) && Files.isWritable(path)) {
                this.outputDir = path;
            } else {
                LOG.warn("Unable to configure {}: not a valid output directory", new Object[]{path.toAbsolutePath().toString()});
            }
        }
        if (StringUtil.isNotBlank((String)(cfgPrefix = config.getParameter("prefix", "frame")))) {
            this.prefix = cfgPrefix;
        }
        if (this.outputDir != null) {
            this.generator = new Generator(this.getPolicy(), this.getBufferPool(), false, true);
        }
    }
}

