/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;

public class WebSocketExtensionFactory
extends ExtensionFactory {
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;

    public WebSocketExtensionFactory(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.policy = policy;
        this.bufferPool = bufferPool;
    }

    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name = config.getName();
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        Class extClass = this.getExtension(name);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = (Extension)extClass.newInstance();
            if (ext instanceof AbstractExtension) {
                AbstractExtension aext = (AbstractExtension)ext;
                aext.setConfig(config);
                aext.setPolicy(this.policy);
                aext.setBufferPool(this.bufferPool);
            }
            return ext;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, (Throwable)e);
        }
    }
}

