/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;

public class WriteBytesProvider
implements Callback {
    private static final Logger LOG = Log.getLogger(WriteBytesProvider.class);
    private final Generator generator;
    private final Callback flushCallback;
    private LinkedList<FrameEntry> queue;
    private int bufferSize = 2048;
    private FrameEntry active;
    private Throwable failure;
    private ByteBuffer buffer;
    private AtomicBoolean closed;

    public WriteBytesProvider(Generator generator, Callback flushCallback) {
        this.generator = Objects.requireNonNull(generator);
        this.flushCallback = Objects.requireNonNull(flushCallback);
        this.queue = new LinkedList();
        this.closed = new AtomicBoolean(false);
    }

    public void close() {
        this.closed.set(true);
        this.failAll(new EOFException("Connection has been disconnected"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Frame frame, Callback callback) {
        Objects.requireNonNull(frame);
        LOG.debug("enqueue({}, {})", new Object[]{frame, callback});
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            if (this.closed.get()) {
                LOG.debug("Write is closed: {} {}", new Object[]{frame, callback});
                if (callback != null) {
                    callback.failed((Throwable)new IOException("Write is closed"));
                }
                return;
            }
            if (this.failure != null) {
                LOG.debug("Write is in failure: {} {}", new Object[]{frame, callback});
                this.notifySafeFailure(callback, this.failure);
                return;
            }
            FrameEntry entry = new FrameEntry(frame, callback);
            switch (frame.getType()) {
                case PING: {
                    this.queue.addFirst(entry);
                    break;
                }
                case CLOSE: {
                    this.closed.set(true);
                    this.queue.addLast(entry);
                    break;
                }
                default: {
                    this.queue.addLast(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failAll(Throwable t) {
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            boolean notified = false;
            if (this.active != null) {
                this.active.notifyFailure(t);
                notified = true;
            }
            this.failure = t;
            for (FrameEntry fe : this.queue) {
                fe.notifyFailure(t);
                notified = true;
            }
            this.queue.clear();
            if (notified) {
                this.flushCallback.failed(t);
            }
        }
    }

    public void failed(Throwable cause) {
        this.failAll(cause);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer() {
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            if (this.active == null) {
                if (this.queue.isEmpty()) {
                    return null;
                }
                this.active = this.queue.pop();
            }
            if (this.active == null) {
                return null;
            }
            this.buffer = this.active.getByteBuffer();
        }
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            return this.closed.get();
        }
    }

    private void notifySafeFailure(Callback callback, Throwable t) {
        try {
            callback.failed(t);
        }
        catch (Throwable e) {
            LOG.warn("Uncaught exception", e);
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void succeeded() {
        Callback successCallback = null;
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            this.generator.getBufferPool().release(this.buffer);
            if (this.active == null) {
                return;
            }
            if (this.active.frame.remaining() <= 0) {
                successCallback = this.active.callback;
                this.active = null;
            }
            this.flushCallback.succeeded();
        }
        if (successCallback != null) {
            try {
                successCallback.succeeded();
            }
            catch (Throwable t) {
                LOG.warn("Callback failure", t);
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WriteBytesProvider[");
        b.append("flushCallback=").append(this.flushCallback);
        if (this.failure != null) {
            b.append(",failure=").append(this.failure.getClass().getName());
            b.append(":").append(this.failure.getMessage());
        } else {
            b.append(",active=").append(this.active);
            b.append(",queue.size=").append(this.queue.size());
        }
        b.append(']');
        return b.toString();
    }

    private class FrameEntry {
        protected final AtomicBoolean failed = new AtomicBoolean(false);
        protected final Frame frame;
        protected final Callback callback;

        public FrameEntry(Frame frame, Callback callback) {
            this.frame = frame;
            this.callback = callback;
        }

        public ByteBuffer getByteBuffer() {
            ByteBuffer buffer = WriteBytesProvider.this.generator.generate(WriteBytesProvider.this.bufferSize, this.frame);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getByteBuffer() - {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)buffer)});
            }
            return buffer;
        }

        public void notifyFailure(Throwable t) {
            if (!this.failed.getAndSet(true)) {
                WriteBytesProvider.this.notifySafeFailure(this.callback, t);
            }
        }
    }
}

