/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.mux;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.net.websocket.SendResult;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxChannel;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxControlBlock;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxException;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxGenerator;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxParser;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxPhysicalConnectionException;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxRequest;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxedFrame;
import org.eclipse.jetty.websocket.common.extensions.mux.add.MuxAddClient;
import org.eclipse.jetty.websocket.common.extensions.mux.add.MuxAddServer;
import org.eclipse.jetty.websocket.common.extensions.mux.op.MuxAddChannelRequest;
import org.eclipse.jetty.websocket.common.extensions.mux.op.MuxAddChannelResponse;
import org.eclipse.jetty.websocket.common.extensions.mux.op.MuxDropChannel;
import org.eclipse.jetty.websocket.common.extensions.mux.op.MuxFlowControl;
import org.eclipse.jetty.websocket.common.extensions.mux.op.MuxNewChannelSlot;

public class Muxer
implements IncomingFrames,
MuxParser.Listener {
    private static final int CONTROL_CHANNEL_ID = 0;
    private static final Logger LOG = Log.getLogger(Muxer.class);
    private Map<Long, MuxChannel> channels = new HashMap<Long, MuxChannel>();
    private final WebSocketPolicy policy;
    private final LogicalConnection physicalConnection;
    private InetSocketAddress remoteAddress;
    private MuxParser parser;
    private MuxGenerator generator;
    private MuxAddServer addServer;
    private MuxAddClient addClient;
    private UpgradeRequest physicalRequestHeaders;
    private UpgradeResponse physicalResponseHeaders;

    public Muxer(LogicalConnection connection) {
        this.physicalConnection = connection;
        this.policy = connection.getPolicy().clonePolicy();
        this.parser = new MuxParser();
        this.parser.setEvents(this);
        this.generator = new MuxGenerator();
    }

    public MuxAddClient getAddClient() {
        return this.addClient;
    }

    public MuxAddServer getAddServer() {
        return this.addServer;
    }

    public MuxChannel getChannel(long channelId, boolean create) {
        if (channelId == 0L) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Invalid Channel ID");
        }
        MuxChannel channel = this.channels.get(channelId);
        if (channel == null) {
            if (create) {
                channel = new MuxChannel(channelId, this);
                this.channels.put(channelId, channel);
            } else {
                throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Unknown Channel ID");
            }
        }
        return channel;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void incomingError(WebSocketException e) {
        MuxDropChannel.Reason reason = MuxDropChannel.Reason.PHYSICAL_CONNECTION_FAILED;
        String phrase = String.format("%s: %s", ((Object)((Object)e)).getClass().getName(), e.getMessage());
        this.mustFailPhysicalConnection(new MuxPhysicalConnectionException(reason, phrase));
    }

    public void incomingFrame(Frame frame) {
        this.parser.parse(frame);
    }

    public boolean isOpen() {
        return this.physicalConnection.isOpen();
    }

    public String mergeHeaders(List<String> physicalHeaders, String deltaHeaders) {
        return null;
    }

    private void mustFailPhysicalConnection(MuxPhysicalConnectionException muxe) {
        MuxDropChannel drop = muxe.getMuxDropChannel();
        LOG.warn((Throwable)((Object)muxe));
        try {
            this.generator.generate(drop);
        }
        catch (IOException ioe) {
            LOG.warn("Unable to send mux DropChannel", (Throwable)ioe);
        }
        String reason = "Mux[MUST FAIL]" + drop.getPhrase();
        reason = StringUtil.truncate((String)reason, (int)125);
        this.physicalConnection.close(1011, reason);
    }

    @Override
    public void onMuxAddChannelRequest(MuxAddChannelRequest request) {
        if (this.policy.getBehavior() == WebSocketBehavior.CLIENT) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "AddChannelRequest not allowed per spec");
        }
        if (request.getRsv() != 0) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_REQUEST_ENCODING, "RSV Not allowed to be set");
        }
        long channelId = request.getChannelId();
        MuxChannel channel = this.getChannel(channelId, true);
        try {
            switch (request.getEncoding()) {
                case 0: {
                    UpgradeRequest idenReq = MuxRequest.parse(request.getHandshake());
                    this.addServer.handshake(this, channel, idenReq);
                    break;
                }
                case 1: {
                    UpgradeRequest baseReq = this.addServer.getPhysicalHandshakeRequest();
                    UpgradeRequest deltaReq = MuxRequest.parse(request.getHandshake());
                    UpgradeRequest mergedReq = MuxRequest.merge(baseReq, deltaReq);
                    this.addServer.handshake(this, channel, mergedReq);
                    break;
                }
                default: {
                    throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.BAD_REQUEST, "Unrecognized request encoding");
                }
            }
        }
        catch (MuxPhysicalConnectionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.BAD_REQUEST, "Unable to parse request", t);
        }
    }

    @Override
    public void onMuxAddChannelResponse(MuxAddChannelResponse response) {
        if (this.policy.getBehavior() == WebSocketBehavior.SERVER) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "AddChannelResponse not allowed per spec");
        }
        if (response.getRsv() != 0) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_RESPONSE_ENCODING, "RSV Not allowed to be set");
        }
        long channelId = response.getChannelId();
        MuxChannel channel = this.getChannel(channelId, false);
        try {
            channel.onOpen();
        }
        catch (Throwable t) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.BAD_RESPONSE, "Unable to parse response", t);
        }
    }

    @Override
    public void onMuxDropChannel(MuxDropChannel drop) {
        long channelId = drop.getChannelId();
        MuxChannel channel = this.getChannel(channelId, false);
        String reason = "Mux " + drop.toString();
        reason = StringUtil.truncate((String)reason, (int)123);
        channel.close(1002, reason);
    }

    @Override
    public void onMuxedFrame(MuxedFrame frame) {
        MuxChannel subchannel = this.channels.get(frame.getChannelId());
        subchannel.incomingFrame(frame);
    }

    @Override
    public void onMuxException(MuxException e) {
        if (e instanceof MuxPhysicalConnectionException) {
            this.mustFailPhysicalConnection((MuxPhysicalConnectionException)e);
        }
        LOG.warn((Throwable)((Object)e));
    }

    @Override
    public void onMuxFlowControl(MuxFlowControl flow) {
        if (flow.getSendQuotaSize() > Long.MAX_VALUE) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.SEND_QUOTA_OVERFLOW, "Send Quota Overflow");
        }
        long channelId = flow.getChannelId();
        MuxChannel channel = this.getChannel(channelId, false);
    }

    @Override
    public void onMuxNewChannelSlot(MuxNewChannelSlot slot) {
        if (this.policy.getBehavior() == WebSocketBehavior.SERVER) {
            throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "NewChannelSlot not allowed per spec");
        }
        if (slot.isFallback()) {
            if (slot.getNumberOfSlots() == 0L) {
                throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Cannot have 0 number of slots during fallback");
            }
            if (slot.getInitialSendQuota() == 0L) {
                throw new MuxPhysicalConnectionException(MuxDropChannel.Reason.UNKNOWN_MUX_CONTROL_BLOCK, "Cannot have 0 initial send quota during fallback");
            }
        }
    }

    public Future<SendResult> output(long channelId, Frame frame) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("output({}, {})", new Object[]{channelId, frame});
        }
        return this.generator.generate(channelId, frame);
    }

    public void output(MuxControlBlock op) throws IOException {
        this.generator.generate(op);
    }

    public void setAddClient(MuxAddClient addClient) {
        this.addClient = addClient;
    }

    public void setAddServer(MuxAddServer addServer) {
        this.addServer = addServer;
    }

    public void setOutgoingFramesHandler(OutgoingFrames outgoing) {
        this.generator.setOutgoing(outgoing);
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String toString() {
        return String.format("Muxer[subChannels.size=%d]", this.channels.size());
    }
}

