/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.identity;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.websocket.SendResult;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;

@ManagedObject(value="Identity Extension")
public class IdentityExtension
extends AbstractExtension {
    private String id;

    public String getParam(String key) {
        return this.getConfig().getParameter(key, "?");
    }

    @Override
    public void incomingError(WebSocketException e) {
        this.nextIncomingError(e);
    }

    public void incomingFrame(Frame frame) {
        this.nextIncomingFrame(frame);
    }

    public Future<SendResult> outgoingFrame(Frame frame) throws IOException {
        return this.nextOutgoingFrame(frame);
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        StringBuilder s = new StringBuilder();
        s.append(config.getName());
        s.append("@").append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        s.append("[");
        boolean delim = false;
        for (String param : config.getParameterKeys()) {
            if (delim) {
                s.append(';');
            }
            s.append(param).append('=').append(QuotedStringTokenizer.quoteIfNeeded((String)config.getParameter(param, ""), (String)";="));
            delim = true;
        }
        s.append("]");
        this.id = s.toString();
    }

    @Override
    public String toString() {
        return this.id;
    }
}

