/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.net.websocket.SendResult;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressionMethod;
import org.eclipse.jetty.websocket.common.extensions.compress.DeflateCompressionMethod;

public class MessageCompressionExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(MessageCompressionExtension.class);
    private CompressionMethod method;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingFrame(Frame frame) {
        if (frame.getType().isControl() || !frame.isRsv1()) {
            this.nextIncomingFrame(frame);
            return;
        }
        ByteBuffer data = frame.getPayload();
        try {
            this.method.decompress().input(data);
            while (!this.method.decompress().isDone()) {
                ByteBuffer uncompressed = this.method.decompress().process();
                if (uncompressed == null) continue;
                WebSocketFrame out = new WebSocketFrame(frame).setPayload(uncompressed);
                if (!this.method.decompress().isDone()) {
                    out.setFin(false);
                }
                out.setRsv1(false);
                this.nextIncomingFrame(out);
            }
            if (frame.isFin()) {
                this.method.decompress().end();
            }
        }
        finally {
            this.getBufferPool().release(data);
        }
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    @Override
    public boolean isTextDataDecoder() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<SendResult> outgoingFrame(Frame frame) throws IOException {
        if (frame.getType().isControl()) {
            return this.nextOutgoingFrame(frame);
        }
        Future<SendResult> future = null;
        ByteBuffer data = frame.getPayload();
        try {
            this.method.compress().input(data);
            while (!this.method.compress().isDone()) {
                ByteBuffer buf = this.method.compress().process();
                WebSocketFrame out = new WebSocketFrame(frame).setPayload(buf);
                out.setRsv1(true);
                if (!this.method.compress().isDone()) {
                    out.setFin(false);
                    future = this.nextOutgoingFrame(out);
                    continue;
                }
                future = this.nextOutgoingFrame(out);
            }
            if (frame.isFin()) {
                this.method.compress().end();
            }
        }
        finally {
            this.getBufferPool().release(data);
        }
        return future;
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        String methodOptions = config.getParameter("method", "deflate");
        LOG.debug("Method requested: {}", new Object[]{methodOptions});
        this.method = new DeflateCompressionMethod();
    }

    @Override
    public String toString() {
        return String.format("%s[method=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.method);
    }
}

