/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.net.websocket.ClientContainer;
import javax.net.websocket.CloseReason;
import javax.net.websocket.ContainerProvider;
import javax.net.websocket.Encoder;
import javax.net.websocket.MessageHandler;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.SendResult;
import javax.net.websocket.Session;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketConnection;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.events.EventDriver;

@ManagedObject
public class WebSocketSession
extends ContainerLifeCycle
implements Session<Object>,
WebSocketConnection,
IncomingFrames {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final URI requestURI;
    private final EventDriver websocket;
    private final LogicalConnection connection;
    private Set<MessageHandler> messageHandlers = new HashSet<MessageHandler>();
    private List<Encoder> encoders = new ArrayList<Encoder>();
    private ExtensionFactory extensionFactory;
    private boolean active = false;
    private long maximumMessageSize;
    private long inactiveTime;
    private List<String> negotiatedExtensions = new ArrayList<String>();
    private String protocolVersion;
    private String negotiatedSubprotocol;
    private long timeout;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private WebSocketRemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private WebSocketPolicy policy;

    public WebSocketSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        if (requestURI == null) {
            throw new RuntimeException("Request URI cannot be null");
        }
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        MultiMap params = new MultiMap();
        String query = requestURI.getQuery();
        if (StringUtil.isNotBlank((String)query)) {
            UrlEncoded.decodeTo((String)query, (MultiMap)params, (String)"UTF-8");
        }
        for (String name : params.keySet()) {
            List valueList = params.getValues(name);
            String[] valueArr = new String[valueList.size()];
            valueArr = valueList.toArray(valueArr);
            this.parameterMap.put(name, valueArr);
        }
    }

    public void addMessageHandler(MessageHandler listener) {
        this.messageHandlers.add(listener);
    }

    public void close() throws IOException {
        this.connection.close();
    }

    public void close(CloseReason closeStatus) throws IOException {
        this.connection.close(closeStatus.getCloseCode().getCode(), closeStatus.getReasonPhrase());
    }

    public void close(int statusCode, String reason) {
        this.connection.close(statusCode, reason);
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        out.append(indent).append(" +- incomingHandler : ");
        if (this.incomingHandler instanceof Dumpable) {
            ((Dumpable)this.incomingHandler).dump(out, indent + "    ");
        } else {
            out.append(this.incomingHandler.toString()).append('\n');
        }
        out.append(indent).append(" +- outgoingHandler : ");
        if (this.outgoingHandler instanceof Dumpable) {
            ((Dumpable)this.outgoingHandler).dump(out, indent + "    ");
        } else {
            out.append(this.outgoingHandler.toString()).append('\n');
        }
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public ClientContainer getContainer() {
        return ContainerProvider.getClientContainer();
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public long getInactiveTime() {
        return this.inactiveTime;
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public Set<MessageHandler> getMessageHandlers() {
        return Collections.unmodifiableSet(this.messageHandlers);
    }

    public List<String> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    public String getNegotiatedSubprotocol() {
        return this.negotiatedSubprotocol;
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getQueryString() {
        return this.getRequestURI().getQuery();
    }

    public RemoteEndpoint<Object> getRemote() {
        if (!this.isOpen()) {
            throw new WebSocketException("Session has not been opened yet");
        }
        return this.remote;
    }

    public RemoteEndpoint<Object> getRemote(Class<Object> c) {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public String getSubProtocol() {
        return this.getNegotiatedSubprotocol();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void incomingError(WebSocketException e) {
        if (this.connection.isInputClosed()) {
            return;
        }
        this.websocket.incomingError(e);
    }

    public void incomingFrame(Frame frame) {
        if (this.connection.isInputClosed()) {
            return;
        }
        this.incomingHandler.incomingFrame(frame);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isOpen() {
        return this.isActive();
    }

    public boolean isSecure() {
        return this.getRequestURI().getScheme().equalsIgnoreCase("wss");
    }

    public void open() {
        if (this.isOpen()) {
            throw new WebSocketException("Cannot Open WebSocketSession, Already open");
        }
        this.remote = new WebSocketRemoteEndpoint(this.connection, this.outgoingHandler);
        this.active = true;
        this.websocket.setSession(this);
        this.websocket.onConnect();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", new Object[]{this.dump()});
        }
    }

    public void ping(ByteBuffer buf) throws IOException {
        this.remote.sendPing(buf);
    }

    public void removeMessageHandler(MessageHandler listener) {
        this.messageHandlers.remove(listener);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setEncoders(List<Encoder> encoders) {
        this.encoders.clear();
        if (encoders != null) {
            encoders.addAll(encoders);
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    public void setMaximumMessageSize(long length) {
        this.maximumMessageSize = length;
    }

    public void setNegotiatedExtensions(List<String> negotiatedExtensions) {
        this.negotiatedExtensions.clear();
        this.negotiatedExtensions.addAll(negotiatedExtensions);
    }

    public void setNegotiatedSubprotocol(String negotiatedSubprotocol) {
        this.negotiatedSubprotocol = negotiatedSubprotocol;
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public void setTimeout(long seconds) {
        this.timeout = seconds;
    }

    public SuspendToken suspend() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }

    public Future<SendResult> write(byte[] buf, int offset, int len) throws IOException {
        return this.remote.sendBytes(ByteBuffer.wrap(buf, offset, len), null);
    }

    public Future<SendResult> write(ByteBuffer buffer) throws IOException {
        return this.remote.sendBytes(buffer, null);
    }

    public Future<SendResult> write(String message) throws IOException {
        return this.remote.sendString(message, null);
    }
}

