/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.HttpClientProvider;
import org.eclipse.jetty.websocket.client.WebSocketUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketClient
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final HttpClient httpClient;
    private final Supplier<DecoratedObjectFactory> objectFactorySupplier;
    private final WebSocketPolicy policy;
    private final WebSocketExtensionFactory extensionRegistry;
    private final EventDriverFactory eventDriverFactory;
    private final SessionFactory sessionFactory;
    private boolean stopAtShutdown = true;

    public WebSocketClient() {
        this((HttpClient)null);
    }

    public WebSocketClient(HttpClient httpClient) {
        this(httpClient, null);
    }

    public WebSocketClient(HttpClient httpClient, DecoratedObjectFactory objectFactory) {
        this((WebSocketContainerScope)new SimpleContainerScope(new WebSocketPolicy(WebSocketBehavior.CLIENT), null, null, null, objectFactory), null, null, httpClient);
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory) {
        this(sslContextFactory, null, null);
    }

    public WebSocketClient(Executor executor) {
        this(null, executor, null);
    }

    @Deprecated
    public WebSocketClient(ByteBufferPool bufferPool) {
        this(null, null, bufferPool);
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor) {
        this(sslContextFactory, executor, null);
    }

    public WebSocketClient(WebSocketContainerScope scope) {
        this(scope, null, null, null);
    }

    public WebSocketClient(WebSocketContainerScope scope, SslContextFactory sslContextFactory) {
        this(sslContextFactory, scope.getExecutor(), scope.getBufferPool(), scope.getObjectFactory());
    }

    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool) {
        this(sslContextFactory, executor, bufferPool, null);
    }

    private WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory) {
        this((WebSocketContainerScope)new SimpleContainerScope(new WebSocketPolicy(WebSocketBehavior.CLIENT), bufferPool, executor, sslContextFactory, objectFactory));
        this.addBean(this.httpClient);
    }

    public WebSocketClient(WebSocketContainerScope scope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory) {
        this(scope, eventDriverFactory, sessionFactory, null);
    }

    public WebSocketClient(WebSocketContainerScope scope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory, HttpClient httpClient) {
        if (httpClient == null) {
            this.httpClient = HttpClientProvider.get(scope);
            this.addBean(this.httpClient);
        } else {
            this.httpClient = httpClient;
        }
        this.policy = scope.getPolicy().clonePolicy(WebSocketBehavior.CLIENT);
        this.objectFactorySupplier = () -> scope.getObjectFactory();
        this.extensionRegistry = new WebSocketExtensionFactory((WebSocketContainerScope)this);
        this.eventDriverFactory = eventDriverFactory == null ? new EventDriverFactory((WebSocketContainerScope)this) : eventDriverFactory;
        this.sessionFactory = sessionFactory == null ? new WebSocketSessionFactory((WebSocketContainerScope)this) : sessionFactory;
    }

    public Future<Session> connect(Object websocket, URI toUri) throws IOException {
        ClientUpgradeRequest request = new ClientUpgradeRequest(toUri);
        request.setRequestURI(toUri);
        request.setLocalEndpoint(websocket);
        return this.connect(websocket, toUri, request);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request) throws IOException {
        return this.connect(websocket, toUri, request, null);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request, UpgradeListener upgradeListener) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketClient.class.getSimpleName() + "@" + this.hashCode() + " is not started");
        }
        if (!toUri.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank((String)toUri.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = toUri.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        if ("wss".equals(scheme) && this.httpClient.getSslContextFactory() == null) {
            throw new IllegalStateException("HttpClient has no SslContextFactory, wss:// URI's are not supported in this configuration");
        }
        request.setRequestURI(toUri);
        request.setLocalEndpoint(websocket);
        for (ExtensionConfig reqExt : request.getExtensions()) {
            if (this.extensionRegistry.isAvailable(reqExt.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + reqExt.getName() + "] is not installed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect websocket {} to {}", new Object[]{websocket, toUri});
        }
        this.init();
        WebSocketUpgradeRequest wsReq = new WebSocketUpgradeRequest(this, this.httpClient, request);
        wsReq.setUpgradeListener(upgradeListener);
        return wsReq.sendAsync();
    }

    protected void doStart() throws Exception {
        Objects.requireNonNull(this.httpClient, "Provided HttpClient is null");
        super.doStart();
        if (!this.httpClient.isRunning()) {
            throw new IllegalStateException("HttpClient is not running (did you forget to start it?): " + this.httpClient);
        }
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", new Object[]{this});
        }
        ShutdownThread.deregister((LifeCycle)this);
        super.doStop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", new Object[]{this});
        }
    }

    @Deprecated
    public boolean isDispatchIO() {
        return this.httpClient.isDispatchIO();
    }

    public long getAsyncWriteTimeout() {
        return this.getPolicy().getAsyncWriteTimeout();
    }

    public SocketAddress getBindAddress() {
        return this.httpClient.getBindAddress();
    }

    public ByteBufferPool getBufferPool() {
        return this.httpClient.getByteBufferPool();
    }

    @Deprecated
    public ConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public long getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public CookieStore getCookieStore() {
        return this.httpClient.getCookieStore();
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    public Executor getExecutor() {
        return this.httpClient.getExecutor();
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    @Deprecated
    public Masker getMasker() {
        return new RandomMasker();
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.getPolicy().getMaxBinaryMessageBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.getPolicy().getMaxBinaryMessageSize();
    }

    public long getMaxIdleTimeout() {
        return this.getPolicy().getIdleTimeout();
    }

    public int getMaxTextMessageBufferSize() {
        return this.getPolicy().getMaxTextMessageBufferSize();
    }

    public long getMaxTextMessageSize() {
        return this.getPolicy().getMaxTextMessageSize();
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactorySupplier.get();
    }

    public Set<WebSocketSession> getOpenSessions() {
        return Collections.unmodifiableSet(new HashSet(this.getBeans(WebSocketSession.class)));
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.httpClient.getScheduler();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public SslContextFactory getSslContextFactory() {
        return this.httpClient.getSslContextFactory();
    }

    private synchronized void init() throws IOException {
        if (this.isStopAtShutdown() && !ShutdownThread.isRegistered((LifeCycle)this)) {
            ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
        }
    }

    @Deprecated
    protected ConnectionManager newConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public void onSessionClosed(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Closed: {}", new Object[]{session});
        }
        this.removeBean(session);
    }

    public void onSessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", new Object[]{session});
        }
        this.addManaged((LifeCycle)session);
        LOG.debug("post-onSessionOpened() - {}", new Object[]{this});
    }

    public void setAsyncWriteTimeout(long ms) {
        this.getPolicy().setAsyncWriteTimeout(ms);
    }

    @Deprecated
    public void setBindAdddress(SocketAddress bindAddress) {
        this.setBindAddress(bindAddress);
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.httpClient.setBindAddress(bindAddress);
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.httpClient.setByteBufferPool(bufferPool);
    }

    public void setConnectTimeout(long ms) {
        this.httpClient.setConnectTimeout(ms);
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpClient.setCookieStore(cookieStore);
    }

    @Deprecated
    public void setDaemon(boolean daemon) {
    }

    @Deprecated
    public void setDispatchIO(boolean dispatchIO) {
        this.httpClient.setDispatchIO(dispatchIO);
    }

    public void setExecutor(Executor executor) {
        this.httpClient.setExecutor(executor);
    }

    @Deprecated
    public void setMasker(Masker masker) {
    }

    public void setMaxBinaryMessageBufferSize(int max) {
        this.getPolicy().setMaxBinaryMessageBufferSize(max);
    }

    public void setMaxIdleTimeout(long ms) {
        this.getPolicy().setIdleTimeout(ms);
        this.httpClient.setIdleTimeout(ms);
    }

    public void setMaxTextMessageBufferSize(int max) {
        this.getPolicy().setMaxTextMessageBufferSize(max);
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        WebSocketClient.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this.getOpenSessions()});
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public synchronized void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this.stopAtShutdown && this.isStarted() && !ShutdownThread.isRegistered((LifeCycle)this)) {
                ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
            }
        } else {
            ShutdownThread.deregister((LifeCycle)this);
        }
        this.stopAtShutdown = stop;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSocketClient)) {
            return false;
        }
        WebSocketClient that = (WebSocketClient)((Object)o);
        return Objects.equals(this.httpClient, that.httpClient) && Objects.equals(this.policy, that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.httpClient, this.policy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebSocketClient@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append("[httpClient=").append(this.httpClient);
        sb.append(",openSessions.size=");
        sb.append(this.getOpenSessions().size());
        sb.append(']');
        return sb.toString();
    }
}

