/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.UpgradeConnection;

public class WebSocketClientSelectorManager
extends SelectorManager {
    private static final Logger LOG = Log.getLogger(WebSocketClientSelectorManager.class);
    private final WebSocketPolicy policy;
    private final ByteBufferPool bufferPool;
    private SslContextFactory sslContextFactory;

    public WebSocketClientSelectorManager(WebSocketClient client) {
        super(client.getExecutor(), client.getScheduler());
        this.bufferPool = client.getBufferPool();
        this.policy = client.getPolicy();
    }

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection Failed", ex);
        }
        ConnectPromise connect = (ConnectPromise)attachment;
        connect.failed(ex);
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("newConnection({},{},{})", new Object[]{channel, endPoint, attachment});
        }
        ConnectPromise connectPromise = (ConnectPromise)attachment;
        try {
            String scheme = connectPromise.getRequest().getRequestURI().getScheme();
            if ("wss".equalsIgnoreCase(scheme)) {
                SslContextFactory sslContextFactory = this.getSslContextFactory();
                if (sslContextFactory != null) {
                    SSLEngine engine = this.newSSLEngine(sslContextFactory, channel);
                    SslConnection sslConnection = new SslConnection(this.bufferPool, this.getExecutor(), endPoint, engine, true, true);
                    sslConnection.setRenegotiationAllowed(sslContextFactory.isRenegotiationAllowed());
                    sslConnection.setRenegotiationLimit(sslContextFactory.getRenegotiationLimit());
                    SslConnection.DecryptedEndPoint sslEndPoint = sslConnection.getDecryptedEndPoint();
                    UpgradeConnection connection = this.newUpgradeConnection(channel, (EndPoint)sslEndPoint, connectPromise);
                    sslEndPoint.setIdleTimeout(connectPromise.getClient().getMaxIdleTimeout());
                    sslEndPoint.setConnection((Connection)connection);
                    return sslConnection;
                }
                throw new IOException("Cannot init SSL");
            }
            endPoint.setIdleTimeout(connectPromise.getDriver().getPolicy().getIdleTimeout());
            return this.newUpgradeConnection(channel, endPoint, connectPromise);
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
            connectPromise.failed(e);
            throw e;
        }
    }

    protected EndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey selectionKey) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("newEndPoint({}, {}, {})", new Object[]{channel, selectSet, selectionKey});
        }
        return new SelectChannelEndPoint(channel, selectSet, selectionKey, this.getScheduler(), this.policy.getIdleTimeout());
    }

    public SSLEngine newSSLEngine(SslContextFactory sslContextFactory, SocketChannel channel) {
        String peerHost = channel.socket().getInetAddress().getHostName();
        int peerPort = channel.socket().getPort();
        SSLEngine engine = sslContextFactory.newSSLEngine(peerHost, peerPort);
        engine.setUseClientMode(true);
        return engine;
    }

    public UpgradeConnection newUpgradeConnection(SocketChannel channel, EndPoint endPoint, ConnectPromise connectPromise) {
        WebSocketClient client = connectPromise.getClient();
        Executor executor = client.getExecutor();
        UpgradeConnection connection = new UpgradeConnection(endPoint, executor, connectPromise);
        return connection;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }
}

