/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;

public class ClientUpgradeRequest
extends UpgradeRequest {
    private static final Logger LOG = Log.getLogger(ClientUpgradeRequest.class);
    private static final int MAX_KEYS = -1;
    private static final Set<String> FORBIDDEN_HEADERS = new HashSet<String>();
    private final String key = this.genRandomKey();

    public ClientUpgradeRequest() {
    }

    protected ClientUpgradeRequest(URI requestURI) {
        super(requestURI);
    }

    public String generate() {
        List cookies;
        boolean needDelim;
        URI uri = this.getRequestURI();
        StringBuilder request = new StringBuilder(512);
        request.append("GET ");
        if (StringUtil.isBlank((String)uri.getPath())) {
            request.append("/");
        } else {
            request.append(uri.getPath());
        }
        if (StringUtil.isNotBlank((String)uri.getRawQuery())) {
            request.append("?").append(uri.getRawQuery());
        }
        request.append(" HTTP/1.1\r\n");
        request.append("Host: ").append(uri.getHost());
        if (uri.getPort() > 0) {
            request.append(':').append(uri.getPort());
        }
        request.append("\r\n");
        request.append("Upgrade: websocket\r\n");
        request.append("Connection: Upgrade\r\n");
        request.append("Sec-WebSocket-Key: ").append(this.key).append("\r\n");
        request.append("Sec-WebSocket-Version: 13\r\n");
        request.append("Pragma: no-cache\r\n");
        request.append("Cache-Control: no-cache\r\n");
        if (!this.getExtensions().isEmpty()) {
            request.append("Sec-WebSocket-Extensions: ");
            needDelim = false;
            for (ExtensionConfig ext : this.getExtensions()) {
                if (needDelim) {
                    request.append(", ");
                }
                request.append(ext.getParameterizedName());
                needDelim = true;
            }
            request.append("\r\n");
        }
        if (!this.getSubProtocols().isEmpty()) {
            request.append("Sec-WebSocket-Protocol: ");
            needDelim = false;
            for (String protocol : this.getSubProtocols()) {
                if (needDelim) {
                    request.append(", ");
                }
                request.append(protocol);
                needDelim = true;
            }
            request.append("\r\n");
        }
        if ((cookies = this.getCookies()) != null && cookies.size() > 0) {
            request.append("Cookie: ");
            boolean needDelim2 = false;
            for (HttpCookie cookie : cookies) {
                if (needDelim2) {
                    request.append("; ");
                }
                request.append(cookie.toString());
                needDelim2 = true;
            }
            request.append("\r\n");
        }
        for (String key : this.getHeaders().keySet()) {
            if (FORBIDDEN_HEADERS.contains(key)) {
                LOG.warn("Skipping forbidden header - {}", new Object[]{key});
                continue;
            }
            request.append(key).append(": ");
            request.append(this.getHeader(key));
            request.append("\r\n");
        }
        request.append("\r\n");
        return request.toString();
    }

    private final String genRandomKey() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        return new String(B64Code.encode((byte[])bytes));
    }

    public String getKey() {
        return this.key;
    }

    public void setCookiesFrom(CookieStore cookieStore) {
        if (cookieStore == null) {
            return;
        }
        this.setCookies(cookieStore.get(this.getRequestURI()));
    }

    public void setRequestURI(URI uri) {
        super.setRequestURI(uri);
        HashMap pmap = new HashMap();
        String query = uri.getQuery();
        if (StringUtil.isNotBlank((String)query)) {
            MultiMap params = new MultiMap();
            UrlEncoded.decodeTo((String)uri.getQuery(), (MultiMap)params, (Charset)StandardCharsets.UTF_8, (int)-1);
            for (String key : params.keySet()) {
                List values = params.getValues(key);
                if (values == null) {
                    pmap.put(key, new ArrayList());
                    continue;
                }
                ArrayList copy = new ArrayList();
                copy.addAll(values);
                pmap.put(key, copy);
            }
            super.setParameterMap(pmap);
        }
    }

    static {
        FORBIDDEN_HEADERS.add("cookie");
        FORBIDDEN_HEADERS.add("upgrade");
        FORBIDDEN_HEADERS.add("host");
        FORBIDDEN_HEADERS.add("connection");
        FORBIDDEN_HEADERS.add("sec-websocket-key");
        FORBIDDEN_HEADERS.add("sec-websocket-extensions");
        FORBIDDEN_HEADERS.add("sec-websocket-accept");
        FORBIDDEN_HEADERS.add("sec-websocket-protocol");
        FORBIDDEN_HEADERS.add("sec-websocket-version");
        FORBIDDEN_HEADERS.add("pragma");
        FORBIDDEN_HEADERS.add("cache-control");
    }
}

