/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.internal.DefaultWebSocketClient;
import org.eclipse.jetty.websocket.client.internal.io.WebSocketClientSelectorManager;

public class ConnectionManager
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(ConnectionManager.class);
    private final Queue<DefaultWebSocketClient> clients = new ConcurrentLinkedQueue<DefaultWebSocketClient>();
    private final WebSocketClientSelectorManager selector;

    public static InetSocketAddress toSocketAddress(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Cannot get InetSocketAddress of non-absolute URIs");
        }
        int port = uri.getPort();
        String scheme = uri.getScheme().toLowerCase(Locale.ENGLISH);
        if ("ws".equals(scheme)) {
            if (port == -1) {
                port = 80;
            }
        } else if ("wss".equals(scheme)) {
            if (port == -1) {
                port = 443;
            }
        } else {
            throw new IllegalArgumentException("Only support ws:// and wss:// URIs");
        }
        return new InetSocketAddress(uri.getHost(), port);
    }

    public ConnectionManager(ByteBufferPool bufferPool, Executor executor, Scheduler scheduler, SslContextFactory sslContextFactory, WebSocketPolicy policy) {
        this.selector = new WebSocketClientSelectorManager(bufferPool, executor, scheduler, policy);
        this.selector.setSslContextFactory(sslContextFactory);
        this.addBean((Object)this.selector);
    }

    public void addClient(DefaultWebSocketClient client) {
        this.clients.add(client);
    }

    private void closeAllConnections() {
        for (DefaultWebSocketClient client : this.clients) {
            if (client.getConnection() == null) continue;
            try {
                client.getConnection().close();
            }
            catch (IOException e) {
                LOG.debug("During Close All Connections", (Throwable)e);
            }
        }
    }

    public Future<ClientUpgradeResponse> connectPhysical(DefaultWebSocketClient client) throws IOException {
        SocketChannel channel = SocketChannel.open();
        SocketAddress bindAddress = client.getFactory().getBindAddress();
        if (bindAddress != null) {
            channel.bind(bindAddress);
        }
        URI wsUri = client.getWebSocketUri();
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
        InetSocketAddress address = ConnectionManager.toSocketAddress(wsUri);
        LOG.debug("Connect to {}", new Object[]{address});
        channel.connect(address);
        this.getSelector().connect(channel, client);
        return client;
    }

    public Future<ClientUpgradeResponse> connectVirtual(WebSocketClient client) {
        return null;
    }

    protected void doStop() throws Exception {
        this.closeAllConnections();
        this.clients.clear();
        super.doStop();
    }

    public Collection<DefaultWebSocketClient> getClients() {
        return Collections.unmodifiableCollection(this.clients);
    }

    public WebSocketClientSelectorManager getSelector() {
        return this.selector;
    }
}

