/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal.io;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.WebSocketClientFactory;
import org.eclipse.jetty.websocket.client.internal.DefaultWebSocketClient;
import org.eclipse.jetty.websocket.client.internal.io.UpgradeConnection;

public class WebSocketClientSelectorManager
extends SelectorManager {
    private static final Logger LOG = Log.getLogger(WebSocketClientSelectorManager.class);
    private final WebSocketPolicy policy;
    private final ByteBufferPool bufferPool;
    private SslContextFactory sslContextFactory;

    public WebSocketClientSelectorManager(ByteBufferPool bufferPool, Executor executor, Scheduler scheduler, WebSocketPolicy policy) {
        super(executor, scheduler);
        this.bufferPool = bufferPool;
        this.policy = policy;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) throws IOException {
        LOG.debug("newConnection({},{},{})", new Object[]{channel, endPoint, attachment});
        DefaultWebSocketClient client = (DefaultWebSocketClient)attachment;
        try {
            String scheme = client.getWebSocketUri().getScheme();
            if ("wss".equalsIgnoreCase(scheme)) {
                if (this.sslContextFactory != null) {
                    SSLEngine engine = this.newSSLEngine(this.sslContextFactory, channel);
                    SslConnection sslConnection = new SslConnection(this.bufferPool, this.getExecutor(), endPoint, engine);
                    SslConnection.DecryptedEndPoint sslEndPoint = sslConnection.getDecryptedEndPoint();
                    UpgradeConnection connection = this.newUpgradeConnection(channel, (EndPoint)sslEndPoint, client);
                    sslEndPoint.setConnection((Connection)connection);
                    this.connectionOpened((Connection)connection);
                    return sslConnection;
                }
                throw new IOException("Cannot init SSL");
            }
            return this.newUpgradeConnection(channel, endPoint, client);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            client.failed(null, (Throwable)e);
            throw e;
        }
    }

    protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selectSet, SelectionKey selectionKey) throws IOException {
        LOG.debug("newEndPoint({}, {}, {})", new Object[]{channel, selectSet, selectionKey});
        return new SelectChannelEndPoint(channel, selectSet, selectionKey, this.getScheduler(), (long)this.policy.getIdleTimeout());
    }

    public SSLEngine newSSLEngine(SslContextFactory sslContextFactory, SocketChannel channel) {
        String peerHost = channel.socket().getInetAddress().getHostAddress();
        int peerPort = channel.socket().getPort();
        SSLEngine engine = sslContextFactory.newSSLEngine(peerHost, peerPort);
        engine.setUseClientMode(true);
        return engine;
    }

    public UpgradeConnection newUpgradeConnection(SocketChannel channel, EndPoint endPoint, DefaultWebSocketClient client) {
        WebSocketClientFactory factory = client.getFactory();
        Executor executor = factory.getExecutor();
        UpgradeConnection connection = new UpgradeConnection(endPoint, executor, client);
        factory.getConnectionManager().addClient(client);
        return connection;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }
}

