/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api;

import java.net.HttpCookie;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class UpgradeRequest {
    private URI requestURI;
    private List<String> subProtocols = new ArrayList<String>();
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
    private List<HttpCookie> cookies = new ArrayList<HttpCookie>();
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private Object session;
    private String httpVersion;
    private String method;
    private String host;
    private boolean secure = false;

    protected UpgradeRequest() {
    }

    public UpgradeRequest(String requestURI) {
        this(URI.create(requestURI));
    }

    public UpgradeRequest(URI requestURI) {
        this();
        this.setRequestURI(requestURI);
    }

    public void addExtensions(ExtensionConfig ... configs) {
        for (ExtensionConfig config : configs) {
            this.extensions.add(config);
        }
    }

    public void addExtensions(String ... configs) {
        for (String config : configs) {
            this.extensions.add(ExtensionConfig.parse(config));
        }
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public List<HttpCookie> getCookies() {
        return this.cookies;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        int size = values.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return values.get(0);
        }
        boolean needsDelim = false;
        StringBuilder ret = new StringBuilder();
        for (String value : values) {
            if (needsDelim) {
                ret.append(", ");
            }
            QuoteUtil.quoteIfNeeded(ret, value, "\"'\\\n\r\t\f\b%+ ;=");
            needsDelim = true;
        }
        return ret.toString();
    }

    public int getHeaderInt(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return -1;
        }
        int size = values.size();
        if (size <= 0) {
            return -1;
        }
        if (size == 1) {
            return Integer.parseInt(values.get(0));
        }
        throw new NumberFormatException("Cannot convert multi-value header into int");
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String name) {
        return this.headers.get(name);
    }

    public String getHost() {
        return this.host;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getMethod() {
        return this.method;
    }

    public String getOrigin() {
        return this.getHeader("Origin");
    }

    public Map<String, List<String>> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getProtocolVersion() {
        String version = this.getHeader("Sec-WebSocket-Version");
        if (version == null) {
            return "13";
        }
        return version;
    }

    public String getQueryString() {
        return this.requestURI.getQuery();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public Object getSession() {
        return this.session;
    }

    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean hasSubProtocol(String test) {
        for (String protocol : this.subProtocols) {
            if (!protocol.equalsIgnoreCase(test)) continue;
            return true;
        }
        return false;
    }

    public boolean isOrigin(String test) {
        return test.equalsIgnoreCase(this.getOrigin());
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setCookies(List<HttpCookie> cookies) {
        this.cookies = cookies;
    }

    public void setExtensions(List<ExtensionConfig> configs) {
        this.extensions.clear();
        if (configs != null) {
            this.extensions.addAll(configs);
        }
    }

    public void setHeader(String name, List<String> values) {
        this.headers.put(name, values);
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.setHeader(name, values);
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.clearHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            this.setHeader(name, values);
        }
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    protected void setParameterMap(Map<String, List<String>> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public void setRequestURI(URI uri) {
        this.requestURI = uri;
        String scheme = uri.getScheme();
        if ("ws".equalsIgnoreCase(scheme)) {
            this.secure = false;
        } else if ("wss".equalsIgnoreCase(scheme)) {
            this.secure = true;
        } else {
            throw new IllegalArgumentException("URI scheme must be 'ws' or 'wss'");
        }
        this.host = this.requestURI.getHost();
        this.parameters.clear();
    }

    public void setSession(Object session) {
        this.session = session;
    }

    public void setSubProtocols(List<String> subProtocols) {
        this.subProtocols.clear();
        if (subProtocols != null) {
            this.subProtocols.addAll(subProtocols);
        }
    }

    public void setSubProtocols(String ... protocols) {
        this.subProtocols.clear();
        for (String protocol : protocols) {
            this.subProtocols.add(protocol);
        }
    }
}

