/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;

public class MessageWriter
extends Writer {
    private static final Logger LOG = Log.getLogger(MessageWriter.class);
    private final CharsetEncoder utf8Encoder = StandardCharsets.UTF_8.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
    private final FrameHandler.CoreSession coreSession;
    private final SharedBlockingCallback blocker;
    private long frameCount;
    private Frame frame;
    private CharBuffer buffer;
    private Callback callback;
    private boolean closed;

    public MessageWriter(FrameHandler.CoreSession coreSession, int bufferSize) {
        this.coreSession = coreSession;
        this.blocker = new SharedBlockingCallback();
        this.buffer = CharBuffer.allocate(bufferSize);
        this.frame = new Frame(1);
    }

    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        try {
            this.send(chars, off, len);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    @Override
    public void write(int c) throws IOException {
        try {
            this.send(new char[]{(char)c}, 0, 1);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.flush(false);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean fin) throws IOException {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.closed = fin;
            this.buffer.flip();
            ByteBuffer payload = this.utf8Encoder.encode(this.buffer);
            this.buffer.flip();
            if (LOG.isDebugEnabled()) {
                LOG.debug("flush({}): {}", new Object[]{fin, BufferUtil.toDetailString((ByteBuffer)payload)});
            }
            this.frame.setPayload(payload);
            this.frame.setFin(fin);
            try (SharedBlockingCallback.Blocker b = this.blocker.acquire();){
                this.coreSession.sendFrame(this.frame, (Callback)b, false);
                b.block();
            }
            ++this.frameCount;
            this.frame = new Frame(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(char[] chars, int offset, int length) throws IOException {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            CharBuffer source = CharBuffer.wrap(chars, offset, length);
            int remaining = length;
            while (remaining > 0) {
                int read = source.read(this.buffer);
                if (read == -1) {
                    return;
                }
                if ((remaining -= read) <= 0) continue;
                this.flush(false);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream closed, {} frames sent", this.frameCount);
            }
            this.notifySuccess();
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback callback) {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            this.callback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuccess() {
        Callback callback;
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            callback = this.callback;
        }
        if (callback != null) {
            callback.succeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure(Throwable failure) {
        Callback callback;
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            callback = this.callback;
        }
        if (callback != null) {
            callback.failed(failure);
        }
    }
}

