/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.common.JettyWebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.core.FrameHandler;

public class WebSocketSession
extends AbstractLifeCycle
implements Session,
SuspendToken,
Dumpable {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final FrameHandler.CoreSession coreSession;
    private final JettyWebSocketFrameHandler frameHandler;
    private final JettyWebSocketRemoteEndpoint remoteEndpoint;
    private final UpgradeRequest upgradeRequest;
    private final UpgradeResponse upgradeResponse;

    public WebSocketSession(FrameHandler.CoreSession coreSession, JettyWebSocketFrameHandler frameHandler) {
        this.frameHandler = Objects.requireNonNull(frameHandler);
        this.coreSession = Objects.requireNonNull(coreSession);
        this.upgradeRequest = frameHandler.getUpgradeRequest();
        this.upgradeResponse = frameHandler.getUpgradeResponse();
        this.remoteEndpoint = new JettyWebSocketRemoteEndpoint(coreSession, frameHandler.getBatchMode());
    }

    public void close() {
        this.remoteEndpoint.close();
    }

    public void close(CloseStatus closeStatus) {
        this.remoteEndpoint.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    public void close(int statusCode, String reason) {
        this.remoteEndpoint.close(statusCode, reason);
    }

    public WebSocketBehavior getBehavior() {
        switch (this.coreSession.getBehavior()) {
            case CLIENT: {
                return WebSocketBehavior.CLIENT;
            }
            case SERVER: {
                return WebSocketBehavior.SERVER;
            }
        }
        return null;
    }

    public Duration getIdleTimeout() {
        return this.coreSession.getIdleTimeout();
    }

    public int getInputBufferSize() {
        return this.coreSession.getInputBufferSize();
    }

    public int getOutputBufferSize() {
        return this.coreSession.getOutputBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.coreSession.getMaxBinaryMessageSize();
    }

    public long getMaxTextMessageSize() {
        return this.coreSession.getMaxTextMessageSize();
    }

    public void setIdleTimeout(Duration duration) {
        this.coreSession.setIdleTimeout(duration);
    }

    public void setInputBufferSize(int size) {
        this.coreSession.setInputBufferSize(size);
    }

    public void setOutputBufferSize(int size) {
        this.coreSession.setOutputBufferSize(size);
    }

    public void setMaxBinaryMessageSize(long size) {
        this.coreSession.setMaxBinaryMessageSize(size);
    }

    public void setMaxTextMessageSize(long size) {
        this.coreSession.setMaxTextMessageSize(size);
    }

    public String getProtocolVersion() {
        return this.upgradeRequest.getProtocolVersion();
    }

    public JettyWebSocketRemoteEndpoint getRemote() {
        return this.remoteEndpoint;
    }

    public boolean isOpen() {
        return this.remoteEndpoint.getCoreSession().isOutputOpen();
    }

    public boolean isSecure() {
        return this.upgradeRequest.isSecure();
    }

    public void disconnect() {
        this.coreSession.abort();
    }

    public SocketAddress getLocalAddress() {
        return this.coreSession.getLocalAddress();
    }

    public SocketAddress getRemoteAddress() {
        return this.coreSession.getRemoteAddress();
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    public SuspendToken suspend() {
        this.frameHandler.suspend();
        return this;
    }

    public void resume() {
        this.frameHandler.resume();
    }

    public FrameHandler.CoreSession getCoreSession() {
        return this.coreSession;
    }

    protected void doStop() throws Exception {
        this.coreSession.close(1001, "Container being shut down", new Callback(){

            public void succeeded() {
                WebSocketSession.this.coreSession.abort();
            }

            public void failed(Throwable x) {
                WebSocketSession.this.coreSession.abort();
            }
        });
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{this.upgradeRequest, this.coreSession, this.remoteEndpoint, this.frameHandler});
    }

    public String dumpSelf() {
        return String.format("%s@%x[behavior=%s,idleTimeout=%dms]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getPolicy().getBehavior(), this.getIdleTimeout().toMillis());
    }

    public String toString() {
        return String.format("WebSocketSession[%s,to=%s,%s,%s]", this.getBehavior(), this.getIdleTimeout(), this.coreSession, this.frameHandler);
    }
}

