/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.Frame;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketConnectionListener;
import org.eclipse.jetty.websocket.api.WebSocketFrameListener;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WebSocketPartialListener;
import org.eclipse.jetty.websocket.api.WebSocketPingPongListener;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.common.MessageSink;
import org.eclipse.jetty.websocket.common.WebSocketContainer;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.invoke.InvalidSignatureException;
import org.eclipse.jetty.websocket.common.invoke.InvokerUtils;
import org.eclipse.jetty.websocket.common.message.ByteArrayMessageSink;
import org.eclipse.jetty.websocket.common.message.ByteBufferMessageSink;
import org.eclipse.jetty.websocket.common.message.InputStreamMessageSink;
import org.eclipse.jetty.websocket.common.message.PartialBinaryMessageSink;
import org.eclipse.jetty.websocket.common.message.PartialTextMessageSink;
import org.eclipse.jetty.websocket.common.message.ReaderMessageSink;
import org.eclipse.jetty.websocket.common.message.StringMessageSink;
import org.eclipse.jetty.websocket.common.util.ReflectUtils;
import org.eclipse.jetty.websocket.core.FrameHandler;

public class JettyWebSocketFrameHandlerFactory
extends ContainerLifeCycle {
    private final WebSocketContainer container;
    private Map<Class<?>, JettyWebSocketFrameHandlerMetadata> metadataMap = new ConcurrentHashMap();

    public JettyWebSocketFrameHandlerFactory(WebSocketContainer container) {
        this.container = container;
    }

    public JettyWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass) {
        JettyWebSocketFrameHandlerMetadata metadata = this.metadataMap.get(endpointClass);
        if (metadata == null) {
            metadata = this.createMetadata(endpointClass);
            this.metadataMap.put(endpointClass, metadata);
        }
        return metadata;
    }

    public JettyWebSocketFrameHandlerMetadata createMetadata(Class<?> endpointClass) {
        if (WebSocketConnectionListener.class.isAssignableFrom(endpointClass)) {
            return this.createListenerMetadata(endpointClass);
        }
        WebSocket websocket = endpointClass.getAnnotation(WebSocket.class);
        if (websocket != null) {
            return this.createAnnotatedMetadata(websocket, endpointClass);
        }
        throw new InvalidWebSocketException("Unrecognized WebSocket endpoint: " + endpointClass.getName());
    }

    public JettyWebSocketFrameHandler newJettyFrameHandler(Object endpointInstance) {
        JettyWebSocketFrameHandlerMetadata metadata = this.getMetadata(endpointInstance.getClass());
        MethodHandle openHandle = JettyWebSocketFrameHandlerFactory.bindTo(metadata.getOpenHandle(), endpointInstance);
        MethodHandle closeHandle = JettyWebSocketFrameHandlerFactory.bindTo(metadata.getCloseHandle(), endpointInstance);
        MethodHandle errorHandle = JettyWebSocketFrameHandlerFactory.bindTo(metadata.getErrorHandle(), endpointInstance);
        MethodHandle textHandle = JettyWebSocketFrameHandlerFactory.bindTo(metadata.getTextHandle(), endpointInstance);
        MethodHandle binaryHandle = JettyWebSocketFrameHandlerFactory.bindTo(metadata.getBinaryHandle(), endpointInstance);
        Class<? extends MessageSink> textSinkClass = metadata.getTextSink();
        Class<? extends MessageSink> binarySinkClass = metadata.getBinarySink();
        MethodHandle frameHandle = JettyWebSocketFrameHandlerFactory.bindTo(metadata.getFrameHandle(), endpointInstance);
        MethodHandle pingHandle = JettyWebSocketFrameHandlerFactory.bindTo(metadata.getPingHandle(), endpointInstance);
        MethodHandle pongHandle = JettyWebSocketFrameHandlerFactory.bindTo(metadata.getPongHandle(), endpointInstance);
        BatchMode batchMode = metadata.getBatchMode();
        JettyWebSocketFrameHandler frameHandler = new JettyWebSocketFrameHandler(this.container, endpointInstance, openHandle, closeHandle, errorHandle, textHandle, binaryHandle, textSinkClass, binarySinkClass, frameHandle, pingHandle, pongHandle, batchMode, (FrameHandler.Customizer)metadata);
        return frameHandler;
    }

    public static MessageSink createMessageSink(MethodHandle msgHandle, Class<? extends MessageSink> sinkClass, Executor executor, WebSocketSession session) {
        if (msgHandle == null) {
            return null;
        }
        if (sinkClass == null) {
            return null;
        }
        try {
            try {
                Constructor<? extends MessageSink> sinkConstructor = sinkClass.getConstructor(Executor.class, MethodHandle.class, Session.class);
                MessageSink messageSink = sinkConstructor.newInstance(new Object[]{executor, msgHandle, session});
                return messageSink;
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<? extends MessageSink> sinkConstructor = sinkClass.getConstructor(Executor.class, MethodHandle.class);
                    MessageSink messageSink = sinkConstructor.newInstance(executor, msgHandle);
                    return messageSink;
                }
                catch (NoSuchMethodException e2) {
                    e.addSuppressed(e2);
                    throw new RuntimeException("Missing expected MessageSink constructor found at: " + sinkClass.getName(), e);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create MessageSink: " + sinkClass.getName(), e);
        }
    }

    public static MethodHandle bindTo(MethodHandle methodHandle, Object ... objs) {
        if (methodHandle == null) {
            return null;
        }
        MethodHandle ret = methodHandle;
        for (Object obj : objs) {
            if (!((Class)ret.type().parameterType(0)).isAssignableFrom(obj.getClass())) continue;
            ret = ret.bindTo(obj);
        }
        return ret;
    }

    private MethodHandle toMethodHandle(MethodHandles.Lookup lookup, Method method) {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access method " + method, e);
        }
    }

    private JettyWebSocketFrameHandlerMetadata createListenerMetadata(Class<?> endpointClass) {
        MethodHandle binary;
        Method binaryMethod;
        MethodHandle text;
        Method textMethod;
        JettyWebSocketFrameHandlerMetadata metadata = new JettyWebSocketFrameHandlerMetadata();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Method openMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketConnect", Session.class);
        MethodHandle open = this.toMethodHandle(lookup, openMethod);
        metadata.setOpenHandler(open, openMethod);
        Method closeMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketClose", Integer.TYPE, String.class);
        MethodHandle close = this.toMethodHandle(lookup, closeMethod);
        metadata.setCloseHandler(close, closeMethod);
        Method errorMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketError", Throwable.class);
        MethodHandle error = this.toMethodHandle(lookup, errorMethod);
        metadata.setErrorHandler(error, errorMethod);
        if (WebSocketListener.class.isAssignableFrom(endpointClass)) {
            textMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketText", String.class);
            text = this.toMethodHandle(lookup, textMethod);
            metadata.setTextHandler(StringMessageSink.class, text, textMethod);
            binaryMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketBinary", byte[].class, Integer.TYPE, Integer.TYPE);
            binary = this.toMethodHandle(lookup, binaryMethod);
            metadata.setBinaryHandle(ByteArrayMessageSink.class, binary, binaryMethod);
        }
        if (WebSocketPingPongListener.class.isAssignableFrom(endpointClass)) {
            Method pongMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketPong", ByteBuffer.class);
            MethodHandle pong = this.toMethodHandle(lookup, pongMethod);
            metadata.setPongHandle(pong, pongMethod);
            Method pingMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketPing", ByteBuffer.class);
            MethodHandle ping = this.toMethodHandle(lookup, pingMethod);
            metadata.setPingHandle(ping, pingMethod);
        }
        if (WebSocketPartialListener.class.isAssignableFrom(endpointClass)) {
            textMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketPartialText", String.class, Boolean.TYPE);
            text = this.toMethodHandle(lookup, textMethod);
            metadata.setTextHandler(PartialTextMessageSink.class, text, textMethod);
            binaryMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketPartialBinary", ByteBuffer.class, Boolean.TYPE);
            binary = this.toMethodHandle(lookup, binaryMethod);
            metadata.setBinaryHandle(PartialBinaryMessageSink.class, binary, binaryMethod);
        }
        if (WebSocketFrameListener.class.isAssignableFrom(endpointClass)) {
            Method frameMethod = ReflectUtils.findMethod(endpointClass, "onWebSocketFrame", Frame.class);
            MethodHandle frame = this.toMethodHandle(lookup, frameMethod);
            metadata.setFrameHandler(frame, frameMethod);
        }
        return metadata;
    }

    private JettyWebSocketFrameHandlerMetadata createAnnotatedMetadata(WebSocket anno, Class<?> endpointClass) {
        Method[] onMessages;
        MethodHandle methodHandle;
        InvokerUtils.Arg SESSION;
        JettyWebSocketFrameHandlerMetadata metadata = new JettyWebSocketFrameHandlerMetadata();
        int max = anno.inputBufferSize();
        if (max >= 0) {
            metadata.setInputBufferSize(max);
        }
        if ((max = anno.maxBinaryMessageSize()) >= 0) {
            metadata.setMaxBinaryMessageSize(max);
        }
        if ((max = anno.maxTextMessageSize()) >= 0) {
            metadata.setMaxTextMessageSize(max);
        }
        if ((max = anno.idleTimeout()) >= 0) {
            metadata.setIdleTimeout(Duration.ofMillis(max));
        }
        metadata.setBatchMode(anno.batchMode());
        Method onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketConnect.class);
        if (onmethod != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketConnect.class);
            SESSION = new InvokerUtils.Arg(Session.class).required();
            MethodHandle methodHandle2 = InvokerUtils.mutatedInvoker(endpointClass, onmethod, SESSION);
            metadata.setOpenHandler(methodHandle2, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketClose.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketClose.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg STATUS_CODE = new InvokerUtils.Arg(Integer.TYPE);
            InvokerUtils.Arg REASON = new InvokerUtils.Arg(String.class);
            MethodHandle methodHandle3 = InvokerUtils.mutatedInvoker(endpointClass, onmethod, SESSION, STATUS_CODE, REASON);
            metadata.setCloseHandler(methodHandle3, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketError.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketError.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CAUSE = new InvokerUtils.Arg(Throwable.class).required();
            methodHandle = InvokerUtils.mutatedInvoker(endpointClass, onmethod, SESSION, CAUSE);
            metadata.setErrorHandler(methodHandle, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketFrame.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketFrame.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg FRAME = new InvokerUtils.Arg(Frame.class).required();
            methodHandle = InvokerUtils.mutatedInvoker(endpointClass, onmethod, SESSION, FRAME);
            metadata.setFrameHandler(methodHandle, onmethod);
        }
        if ((onMessages = ReflectUtils.findAnnotatedMethods(endpointClass, OnWebSocketMessage.class)) != null && onMessages.length > 0) {
            InvokerUtils.Arg[] textCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required()};
            InvokerUtils.Arg[] binaryBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required()};
            InvokerUtils.Arg[] binaryArrayCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(byte[].class).required(), new InvokerUtils.Arg(Integer.TYPE), new InvokerUtils.Arg(Integer.TYPE)};
            InvokerUtils.Arg[] inputStreamCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(InputStream.class).required()};
            InvokerUtils.Arg[] readerCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(Reader.class).required()};
            for (Method onMsg : onMessages) {
                this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                MethodHandle methodHandle4 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, InvokerUtils.PARAM_IDENTITY, textCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setTextHandler(StringMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, InvokerUtils.PARAM_IDENTITY, binaryBufferCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(ByteBufferMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, InvokerUtils.PARAM_IDENTITY, binaryArrayCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(ByteArrayMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, InvokerUtils.PARAM_IDENTITY, inputStreamCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(InputStreamMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, InvokerUtils.PARAM_IDENTITY, readerCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setTextHandler(ReaderMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                throw InvalidSignatureException.build(endpointClass, OnWebSocketMessage.class, onMsg);
            }
        }
        return metadata;
    }

    private void assertSignatureValid(Class<?> endpointClass, Method method, Class<? extends Annotation> annotationClass) {
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must be public: ");
            ReflectUtils.append(err, endpointClass, method);
            throw new InvalidSignatureException(err.toString());
        }
        if (Modifier.isStatic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must not be static: ");
            ReflectUtils.append(err, endpointClass, method);
            throw new InvalidSignatureException(err.toString());
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return;
        }
        StringBuilder err = new StringBuilder();
        err.append("@").append(annotationClass.getSimpleName());
        err.append(" return must be void: ");
        ReflectUtils.append(err, endpointClass, method);
        throw new InvalidSignatureException(err.toString());
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{this.metadataMap});
    }
}

