/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.impl;

import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.impl.DelegatedJettyClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.impl.DelegatedJettyClientUpgradeResponse;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;

public class JettyClientUpgradeRequest
extends ClientUpgradeRequest {
    private final WebSocketClient containerContext;
    private final DelegatedJettyClientUpgradeRequest handshakeRequest;
    private final JettyWebSocketFrameHandler frameHandler;

    public JettyClientUpgradeRequest(WebSocketClient clientContainer, WebSocketCoreClient coreClient, UpgradeRequest request, URI requestURI, Object websocketPojo) {
        super(coreClient, requestURI);
        this.containerContext = clientContainer;
        if (request != null) {
            HttpFields fields = this.getHeaders();
            request.getHeaders().forEach((name, values) -> fields.put(name, values));
            List cookies = request.getCookies();
            if (cookies != null) {
                HttpFields headers = this.getHeaders();
                for (HttpCookie cookie : cookies) {
                    headers.add(HttpHeader.COOKIE, cookie.toString());
                }
            }
            this.setSubProtocols(request.getSubProtocols());
            this.setExtensions(request.getExtensions().stream().map(c -> new ExtensionConfig(c.getName(), c.getParameters())).collect(Collectors.toList()));
            if (request.getMethod() != null) {
                this.method(request.getMethod());
            }
            if (request.getHttpVersion() != null) {
                this.version(HttpVersion.fromString((String)request.getHttpVersion()));
            }
        }
        this.handshakeRequest = new DelegatedJettyClientUpgradeRequest(this);
        this.frameHandler = this.containerContext.newFrameHandler(websocketPojo);
    }

    protected void customize(EndPoint endp) {
        super.customize(endp);
        this.handshakeRequest.configure(endp);
    }

    public void upgrade(HttpResponse response, HttpConnectionOverHTTP httpConnection) {
        this.frameHandler.setUpgradeRequest((UpgradeRequest)new DelegatedJettyClientUpgradeRequest(this));
        this.frameHandler.setUpgradeResponse((UpgradeResponse)new DelegatedJettyClientUpgradeResponse(response));
        super.upgrade(response, httpConnection);
    }

    public FrameHandler getFrameHandler() {
        return this.frameHandler;
    }
}

