/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests.matchers;

import javax.websocket.Decoder;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.decoders.AvailableDecoders;
import org.eclipse.jetty.websocket.javax.common.util.ReflectUtils;
import org.eclipse.jetty.websocket.javax.tests.MessageType;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class IsMessageHandlerType
extends TypeSafeMatcher<MessageHandler> {
    private final JavaxWebSocketSession session;
    private final MessageType expectedType;

    public IsMessageHandlerType(JavaxWebSocketSession session, MessageType expectedType) {
        this.session = session;
        this.expectedType = expectedType;
    }

    public void describeTo(Description description) {
        description.appendText("supports a ");
        switch (this.expectedType) {
            case BINARY: 
            case TEXT: {
                description.appendText(this.expectedType.name()).appendText(" based argument/Decoder");
                break;
            }
            case PONG: {
                description.appendText(PongMessage.class.getName()).appendText(" argument");
                break;
            }
            default: {
                throw new IllegalStateException(this.expectedType.toString());
            }
        }
    }

    protected boolean matchesSafely(MessageHandler messageHandler) {
        Class<?> handlerClass = messageHandler.getClass();
        Class onMessageClass = null;
        if (MessageHandler.Whole.class.isAssignableFrom(handlerClass)) {
            onMessageClass = ReflectUtils.findGenericClassFor(handlerClass, MessageHandler.Whole.class);
        } else if (MessageHandler.Partial.class.isAssignableFrom(handlerClass)) {
            onMessageClass = ReflectUtils.findGenericClassFor(handlerClass, MessageHandler.Partial.class);
        }
        if (onMessageClass == null) {
            return false;
        }
        AvailableDecoders.RegisteredDecoder registeredDecoder = this.session.getDecoders().getRegisteredDecoderFor(onMessageClass);
        if (registeredDecoder == null) {
            return false;
        }
        switch (this.expectedType) {
            case PONG: {
                return PongMessage.class.isAssignableFrom(registeredDecoder.objectType);
            }
            case BINARY: {
                return Decoder.Binary.class.isAssignableFrom(registeredDecoder.interfaceType) || Decoder.BinaryStream.class.isAssignableFrom(registeredDecoder.interfaceType);
            }
            case TEXT: {
                return Decoder.Text.class.isAssignableFrom(registeredDecoder.interfaceType) || Decoder.TextStream.class.isAssignableFrom(registeredDecoder.interfaceType);
            }
        }
        return false;
    }

    public static IsMessageHandlerType isMessageHandlerType(JavaxWebSocketSession session, MessageType messageType) {
        return new IsMessageHandlerType(session, messageType);
    }
}

