/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests.framehandlers;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.MessageHandler;

public class FrameHandlerTracker
extends MessageHandler {
    public CountDownLatch openLatch = new CountDownLatch(1);
    public CountDownLatch closeLatch = new CountDownLatch(1);
    public AtomicReference<CloseStatus> closeDetail = new AtomicReference();
    public AtomicReference<Throwable> error = new AtomicReference();
    public BlockingQueue<String> messageQueue = new LinkedBlockingDeque<String>();
    public BlockingQueue<ByteBuffer> bufferQueue = new LinkedBlockingDeque<ByteBuffer>();
    public BlockingQueue<String> events = new LinkedBlockingDeque<String>();

    public void addEvent(String format, Object ... args) {
        this.events.offer(String.format(format, args));
    }

    public void onOpen(FrameHandler.CoreSession coreSession, Callback callback) {
        super.onOpen(coreSession, Callback.from((Callback)callback, () -> this.openLatch.countDown()));
    }

    public void onText(String wholeMessage, Callback callback) {
        this.messageQueue.offer(wholeMessage);
        callback.succeeded();
    }

    public void onBinary(ByteBuffer wholeMessage, Callback callback) {
        this.bufferQueue.offer(BufferUtil.copy((ByteBuffer)wholeMessage));
        callback.succeeded();
    }

    public void onError(Throwable cause, Callback callback) {
        super.onError(cause, Callback.from((Callback)callback, () -> this.error.compareAndSet(null, cause)));
    }

    public void onClosed(CloseStatus closeStatus, Callback callback) {
        super.onClosed(closeStatus, Callback.from((Callback)callback, () -> {
            this.closeDetail.compareAndSet(null, closeStatus);
            this.closeLatch.countDown();
        }));
    }
}

