/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.internal.Parser;

public class ParserCapture {
    private final Parser parser;
    public BlockingQueue<Frame> framesQueue = new LinkedBlockingDeque<Frame>();
    public boolean closed = false;

    public ParserCapture(Parser parser) {
        this.parser = parser;
    }

    public void parse(ByteBuffer buffer) {
        Parser.ParsedFrame frame;
        while (buffer.hasRemaining() && (frame = this.parser.parse(buffer)) != null && this.onFrame((Frame)frame)) {
        }
    }

    public boolean onFrame(Frame frame) {
        this.framesQueue.offer(Frame.copy((Frame)frame));
        if (frame.getOpCode() == 8) {
            this.closed = true;
        }
        return true;
    }
}

