/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.net.URI;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.OnMessage;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.core.internal.Parser;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSessionListener;
import org.eclipse.jetty.websocket.javax.server.config.JavaxWebSocketServletContainerInitializer;
import org.eclipse.jetty.websocket.javax.server.internal.JavaxWebSocketServerContainer;
import org.eclipse.jetty.websocket.javax.server.internal.JavaxWebSocketServerFrameHandlerFactory;
import org.eclipse.jetty.websocket.javax.tests.BiConsumerServiceServlet;
import org.eclipse.jetty.websocket.javax.tests.Fuzzer;
import org.eclipse.jetty.websocket.javax.tests.LocalFuzzer;
import org.eclipse.jetty.websocket.javax.tests.NetworkFuzzer;
import org.eclipse.jetty.websocket.javax.tests.WSURI;
import org.eclipse.jetty.websocket.servlet.FrameHandlerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class LocalServer
extends ContainerLifeCycle
implements LocalFuzzer.Provider {
    private static final Logger LOG = Log.getLogger(LocalServer.class);
    private final ByteBufferPool bufferPool = new MappedByteBufferPool();
    private Server server;
    private ServerConnector connector;
    private LocalConnector localConnector;
    private ServletContextHandler servletContextHandler;
    private TrackingListener trackingListener = new TrackingListener();
    private URI serverUri;
    private URI wsUri;
    private boolean ssl = false;
    private SslContextFactory.Server sslContextFactory;

    public void enableSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public LocalConnector getLocalConnector() {
        return this.localConnector;
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public ServletContextHandler getServletContextHandler() {
        return this.servletContextHandler;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public URI getWsUri() {
        return this.wsUri;
    }

    public URI getWsUri(Class<?> testClazz, String testName) {
        return this.wsUri.resolve("?testclass=" + testClazz + "&testname=" + testName);
    }

    public URI getTestWsUri(Class<?> clazz, String testName) {
        return this.wsUri.resolve("/test/" + clazz.getSimpleName() + "/" + testName);
    }

    public boolean isSslEnabled() {
        return this.ssl;
    }

    @Override
    public Parser newClientParser() {
        return new Parser(this.bufferPool);
    }

    @Override
    public LocalConnector.LocalEndPoint newLocalConnection() {
        return this.getLocalConnector().connect();
    }

    public Fuzzer newNetworkFuzzer() throws Exception {
        return new NetworkFuzzer(this);
    }

    public Fuzzer newNetworkFuzzer(CharSequence requestPath) throws Exception {
        return new NetworkFuzzer(this, this.getWsUri().resolve(requestPath.toString()));
    }

    public Fuzzer newNetworkFuzzer(CharSequence requestPath, Map<String, String> upgradeRequest) throws Exception {
        return new NetworkFuzzer(this, this.getWsUri().resolve(requestPath.toString()), upgradeRequest);
    }

    protected Handler createRootHandler(Server server) throws Exception {
        this.servletContextHandler = new ServletContextHandler((HandlerContainer)server, "/", true, false);
        this.servletContextHandler.setContextPath("/");
        JavaxWebSocketServletContainerInitializer.configure((ServletContextHandler)this.servletContextHandler, (context, container) -> ((JavaxWebSocketServerContainer)container).addSessionListener((JavaxWebSocketSessionListener)this.trackingListener));
        this.configureServletContextHandler(this.servletContextHandler);
        return this.servletContextHandler;
    }

    protected void configureServletContextHandler(ServletContextHandler context) throws Exception {
    }

    protected void doStart() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("qtp-LocalServer");
        this.server = new Server((ThreadPool)threadPool);
        if (this.ssl) {
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(0);
            httpConfig.setOutputBufferSize(32768);
            httpConfig.setRequestHeaderSize(8192);
            httpConfig.setResponseHeaderSize(8192);
            httpConfig.setSendServerVersion(true);
            httpConfig.setSendDateHeader(false);
            this.sslContextFactory = new SslContextFactory.Server();
            this.sslContextFactory.setKeyStorePath(MavenTestingUtils.getTestResourceFile((String)"keystore").getAbsolutePath());
            this.sslContextFactory.setKeyStorePassword("storepwd");
            this.sslContextFactory.setKeyManagerPassword("keypwd");
            this.sslContextFactory.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(this.sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        } else {
            this.connector = new ServerConnector(this.server);
        }
        this.server.addConnector((Connector)this.connector);
        this.localConnector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.localConnector);
        Handler rootHandler = this.createRootHandler(this.server);
        this.server.setHandler(rootHandler);
        this.addBean(this.server);
        super.doStart();
        String host = this.connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = this.connector.getLocalPort();
        this.serverUri = new URI(String.format("%s://%s:%d/", this.ssl ? "https" : "http", host, port));
        this.wsUri = WSURI.toWebsocket(this.serverUri);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.server.dump(), new Object[0]);
        }
    }

    public void registerHttpService(String urlPattern, BiConsumer<HttpServletRequest, HttpServletResponse> serviceConsumer) {
        ServletHolder holder = new ServletHolder((Servlet)new BiConsumerServiceServlet(serviceConsumer));
        this.servletContextHandler.addServlet(holder, urlPattern);
    }

    public void registerWebSocket(String urlPattern, final WebSocketCreator creator) {
        ServletHolder holder = new ServletHolder((Servlet)new WebSocketServlet(){
            JavaxWebSocketServerFrameHandlerFactory factory = new JavaxWebSocketServerFrameHandlerFactory((JavaxWebSocketContainer)JavaxWebSocketServerContainer.ensureContainer((ServletContext)this.getServletContext()));

            public void configure(WebSocketServletFactory factory) {
                PathSpec pathSpec = factory.parsePathSpec("/");
                factory.addMapping(pathSpec, creator);
            }

            protected FrameHandlerFactory getFactory() {
                return this.factory;
            }
        });
        this.servletContextHandler.addServlet(holder, urlPattern);
    }

    public JavaxWebSocketServerContainer getServerContainer() {
        if (!this.servletContextHandler.isRunning()) {
            throw new IllegalStateException("Cannot access ServerContainer when ServletContextHandler isn't running");
        }
        return JavaxWebSocketServerContainer.getContainer((ServletContext)this.servletContextHandler.getServletContext());
    }

    public Server getServer() {
        return this.server;
    }

    public TrackingListener getTrackingListener() {
        return this.trackingListener;
    }

    public static class TrackingListener
    implements JavaxWebSocketSessionListener {
        private BlockingArrayQueue<JavaxWebSocketSession> openedSessions = new BlockingArrayQueue();
        private BlockingArrayQueue<JavaxWebSocketSession> closedSessions = new BlockingArrayQueue();

        public void onJavaxWebSocketSessionOpened(JavaxWebSocketSession session) {
            this.openedSessions.offer((Object)session);
        }

        public void onJavaxWebSocketSessionClosed(JavaxWebSocketSession session) {
            this.closedSessions.offer((Object)session);
        }

        public BlockingArrayQueue<JavaxWebSocketSession> getOpenedSessions() {
            return this.openedSessions;
        }

        public BlockingArrayQueue<JavaxWebSocketSession> getClosedSessions() {
            return this.closedSessions;
        }
    }

    @ServerEndpoint(value="/echo/text")
    public static class TextEchoSocket {
        @OnMessage
        public String echo(String msg) {
            return msg;
        }
    }
}

