/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.tools.HttpTester;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.internal.Parser;
import org.eclipse.jetty.websocket.javax.tests.Fuzzer;
import org.eclipse.jetty.websocket.javax.tests.ParserCapture;
import org.eclipse.jetty.websocket.javax.tests.UnitGenerator;
import org.eclipse.jetty.websocket.javax.tests.UpgradeUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class LocalFuzzer
extends Fuzzer.Adapter
implements Fuzzer,
AutoCloseable {
    public final Provider provider;
    public final UnitGenerator generator;
    public final LocalConnector.LocalEndPoint endPoint;
    public final HttpTester.Response upgradeResponse;

    public LocalFuzzer(Provider provider) throws Exception {
        this(provider, null);
    }

    public LocalFuzzer(Provider provider, CharSequence requestPath) throws Exception {
        this(provider, requestPath, UpgradeUtils.newDefaultUpgradeRequestHeaders());
    }

    public LocalFuzzer(Provider provider, CharSequence requestPath, Map<String, String> headers) throws Exception {
        this.provider = provider;
        String upgradeRequest = UpgradeUtils.generateUpgradeRequest(requestPath, headers);
        this.logger.debug("Request: {}", new Object[]{upgradeRequest});
        ByteBuffer upgradeRequestBytes = BufferUtil.toBuffer((String)upgradeRequest.toString(), (Charset)StandardCharsets.UTF_8);
        this.endPoint = this.provider.newLocalConnection();
        this.upgradeResponse = this.performUpgrade(this.endPoint, upgradeRequestBytes);
        this.generator = new UnitGenerator(Behavior.CLIENT);
    }

    public void addInputInSegments(LocalConnector.LocalEndPoint endPoint, ByteBuffer outgoing, int segmentSize) {
        while (outgoing.remaining() > 0) {
            int len = Math.min(segmentSize, outgoing.remaining());
            ByteBuffer slice = outgoing.slice();
            slice.limit(len);
            endPoint.addInput(slice);
            outgoing.position(outgoing.position() + len);
        }
    }

    @Override
    public ByteBuffer asNetworkBuffer(List<Frame> frames) {
        int bufferLength = 0;
        for (Frame f : frames) {
            bufferLength += f.getPayloadLength() + 28;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferLength);
        for (Frame f : frames) {
            this.generator.generate(buffer, f);
        }
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        return buffer;
    }

    @Override
    public void close() throws Exception {
        this.endPoint.close();
    }

    @Override
    public void eof() {
        this.endPoint.addInputEOF();
    }

    @Override
    public void expect(List<Frame> expected) throws InterruptedException {
        this.endPoint.waitUntilClosed();
        ByteBuffer incoming = this.endPoint.getOutput();
        ParserCapture capture = new ParserCapture(this.provider.newClientParser());
        capture.parse(incoming);
        this.assertExpected(capture.framesQueue, expected);
    }

    @Override
    public BlockingQueue<Frame> getOutputFrames() {
        this.endPoint.waitUntilClosed();
        ByteBuffer incoming = this.endPoint.getOutput();
        ParserCapture capture = new ParserCapture(this.provider.newClientParser());
        capture.parse(incoming);
        return capture.framesQueue;
    }

    @Override
    public void send(ByteBuffer buffer) {
        this.endPoint.addInput(buffer);
    }

    @Override
    public void send(ByteBuffer buffer, int length) {
        int limit = Math.min(length, buffer.remaining());
        ByteBuffer sliced = buffer.slice();
        sliced.limit(limit);
        this.endPoint.addInput(sliced);
        buffer.position(buffer.position() + limit);
    }

    @Override
    public void sendBulk(List<Frame> frames) {
        int bufferLength = 0;
        for (Frame f : frames) {
            bufferLength += f.getPayloadLength() + 28;
        }
        ByteBuffer outgoing = ByteBuffer.allocate(bufferLength);
        boolean eof = false;
        for (Frame f : frames) {
            this.generator.generate(outgoing, f);
            if (f.getOpCode() != 8) continue;
            eof = true;
        }
        BufferUtil.flipToFlush((ByteBuffer)outgoing, (int)0);
        this.endPoint.addInput(outgoing);
        if (eof) {
            this.endPoint.addInputEOF();
        }
    }

    @Override
    public void sendFrames(List<Frame> frames) {
        boolean eof = false;
        for (Frame f : frames) {
            ByteBuffer buffer = this.generator.generate(f);
            this.endPoint.addInput(buffer);
            if (f.getOpCode() != 8) continue;
            eof = true;
        }
        if (eof) {
            this.endPoint.addInputEOF();
        }
    }

    @Override
    public void sendFrames(Frame ... frames) {
        boolean eof = false;
        for (Frame f : frames) {
            ByteBuffer buffer = this.generator.generate(f);
            this.endPoint.addInput(buffer);
            if (f.getOpCode() != 8) continue;
            eof = true;
        }
        if (eof) {
            this.endPoint.addInputEOF();
        }
    }

    @Override
    public void sendSegmented(List<Frame> frames, int segmentSize) {
        int bufferLength = 0;
        for (Frame f : frames) {
            bufferLength += f.getPayloadLength() + 28;
        }
        ByteBuffer outgoing = ByteBuffer.allocate(bufferLength);
        boolean eof = false;
        for (Frame f : frames) {
            this.generator.generate(outgoing, f);
            if (f.getOpCode() != 8) continue;
            eof = true;
        }
        BufferUtil.flipToFlush((ByteBuffer)outgoing, (int)0);
        this.addInputInSegments(this.endPoint, outgoing, segmentSize);
        if (eof) {
            this.endPoint.addInputEOF();
        }
    }

    private HttpTester.Response performUpgrade(LocalConnector.LocalEndPoint endPoint, ByteBuffer buf) throws Exception {
        endPoint.addInput(buf);
        ByteBuffer response = endPoint.waitForResponse(false, 1L, TimeUnit.SECONDS);
        HttpTester.Response parsedResponse = HttpTester.parseResponse((ByteBuffer)response);
        this.logger.debug("Response: {}", new Object[]{parsedResponse});
        MatcherAssert.assertThat((String)"Is Switching Protocols", (Object)parsedResponse.getStatus(), (Matcher)Matchers.is((Object)101));
        MatcherAssert.assertThat((String)"Is Connection Upgrade", (Object)parsedResponse.get(HttpHeader.SEC_WEBSOCKET_ACCEPT.asString()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Is Connection Upgrade", (Object)parsedResponse.get("Connection"), (Matcher)Matchers.is((Object)"Upgrade"));
        MatcherAssert.assertThat((String)"Is WebSocket Upgrade", (Object)parsedResponse.get("Upgrade"), (Matcher)Matchers.is((Object)"WebSocket"));
        return parsedResponse;
    }

    public static interface Provider {
        public Parser newClientParser();

        public LocalConnector.LocalEndPoint newLocalConnection();
    }
}

