/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.toolchain.test.ByteBufferAssert;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public interface Fuzzer
extends AutoCloseable {
    public ByteBuffer asNetworkBuffer(List<Frame> var1);

    public void eof();

    public void expect(List<Frame> var1) throws InterruptedException;

    public void expectMessage(BlockingQueue<Frame> var1, byte var2, ByteBuffer var3) throws InterruptedException;

    public BlockingQueue<Frame> getOutputFrames();

    public void send(ByteBuffer var1) throws IOException;

    public void send(ByteBuffer var1, int var2) throws IOException;

    public void sendBulk(List<Frame> var1) throws IOException;

    public void sendFrames(List<Frame> var1) throws IOException;

    public void sendFrames(Frame ... var1) throws IOException;

    public void sendSegmented(List<Frame> var1, int var2) throws IOException;

    public static abstract class Adapter {
        protected final Logger logger = Log.getLogger(this.getClass());

        public void expectMessage(BlockingQueue<Frame> framesQueue, byte expectedDataOp, ByteBuffer expectedMessage) throws InterruptedException {
            ByteBuffer actualPayload = ByteBuffer.allocate(expectedMessage.remaining());
            Frame frame = framesQueue.poll(1L, TimeUnit.SECONDS);
            MatcherAssert.assertThat((String)"Initial Frame.opCode", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)expectedDataOp));
            actualPayload.put(frame.getPayload());
            while (!frame.isFin()) {
                frame = framesQueue.poll(1L, TimeUnit.SECONDS);
                MatcherAssert.assertThat((String)"Frame.opCode", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)0));
                actualPayload.put(frame.getPayload());
            }
            actualPayload.flip();
            ByteBufferAssert.assertEquals((String)"Actual Message Payload", (ByteBuffer)actualPayload, (ByteBuffer)expectedMessage);
        }

        public void assertExpected(BlockingQueue<Frame> framesQueue, List<Frame> expect) throws InterruptedException {
            int expectedCount = expect.size();
            for (int i = 0; i < expectedCount; ++i) {
                String prefix = "Frame[" + i + "]";
                Frame expected = expect.get(i);
                Frame actual = framesQueue.poll(3L, TimeUnit.SECONDS);
                MatcherAssert.assertThat((String)(prefix + ".poll"), (Object)actual, (Matcher)Matchers.notNullValue());
                if (this.logger.isDebugEnabled()) {
                    if (actual.getOpCode() == 8) {
                        this.logger.debug("{} CloseFrame: {}", new Object[]{prefix, new CloseStatus(actual.getPayload())});
                    } else {
                        this.logger.debug("{} {}", new Object[]{prefix, actual});
                    }
                }
                MatcherAssert.assertThat((String)(prefix + ".opcode"), (Object)OpCode.name((byte)actual.getOpCode()), (Matcher)Matchers.is((Object)OpCode.name((byte)expected.getOpCode())));
                prefix = prefix + "(op=" + actual.getOpCode() + "," + (actual.isFin() ? "" : "!") + "fin)";
                if (expected.getOpCode() == 8) {
                    CloseStatus expectedClose = new CloseStatus(expected.getPayload());
                    CloseStatus actualClose = new CloseStatus(actual.getPayload());
                    MatcherAssert.assertThat((String)(prefix + ".code"), (Object)actualClose.getCode(), (Matcher)Matchers.is((Object)expectedClose.getCode()));
                    continue;
                }
                if (expected.hasPayload()) {
                    if (expected.getOpCode() == 1) {
                        String expectedText = expected.getPayloadAsUTF8();
                        String actualText = actual.getPayloadAsUTF8();
                        MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.getPayloadLength()));
                        MatcherAssert.assertThat((String)(prefix + ".text-payload"), (Object)actualText, (Matcher)Matchers.is((Object)expectedText));
                        continue;
                    }
                    MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.getPayloadLength()));
                    ByteBufferAssert.assertEquals((String)(prefix + ".payload"), (ByteBuffer)expected.getPayload(), (ByteBuffer)actual.getPayload());
                    continue;
                }
                MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)0));
            }
        }
    }
}

