/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class RawFrameBuilder {
    public static void putOpFin(ByteBuffer buf, byte opcode, boolean fin) {
        byte b = 0;
        if (fin) {
            b = (byte)(b | 0x80);
        }
        b = (byte)(b | opcode & 0xF);
        buf.put(b);
    }

    public static void putLengthAndMask(ByteBuffer buf, int length, byte[] mask) {
        if (mask != null) {
            MatcherAssert.assertThat((String)"Mask.length", (Object)mask.length, (Matcher)Matchers.is((Object)4));
            RawFrameBuilder.putLength(buf, length, mask != null);
            buf.put(mask);
        } else {
            RawFrameBuilder.putLength(buf, length, false);
        }
    }

    public static byte[] mask(byte[] data, byte[] mask) {
        MatcherAssert.assertThat((String)"Mask.length", (Object)mask.length, (Matcher)Matchers.is((Object)4));
        int len = data.length;
        byte[] ret = new byte[len];
        System.arraycopy(data, 0, ret, 0, len);
        for (int i = 0; i < len; ++i) {
            int n = i;
            ret[n] = (byte)(ret[n] ^ mask[i % 4]);
        }
        return ret;
    }

    public static void putLength(ByteBuffer buf, int length, boolean masked) {
        int b;
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        int n = b = masked ? -128 : 0;
        if (length > 65535) {
            buf.put((byte)(b | 0x7F));
            buf.put((byte)0);
            buf.put((byte)0);
            buf.put((byte)0);
            buf.put((byte)0);
            buf.put((byte)(length >> 24 & 0xFF));
            buf.put((byte)(length >> 16 & 0xFF));
            buf.put((byte)(length >> 8 & 0xFF));
            buf.put((byte)(length & 0xFF));
        } else if (length >= 126) {
            buf.put((byte)(b | 0x7E));
            buf.put((byte)(length >> 8));
            buf.put((byte)(length & 0xFF));
        } else {
            buf.put((byte)(b | length));
        }
    }

    public static void putMask(ByteBuffer buf, byte[] mask) {
        MatcherAssert.assertThat((String)"Mask.length", (Object)mask.length, (Matcher)Matchers.is((Object)4));
        buf.put(mask);
    }

    public static void putPayloadLength(ByteBuffer buf, int length) {
        RawFrameBuilder.putLength(buf, length, true);
    }
}

