/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server.deploy;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;

@HandlesTypes(value={ServerApplicationConfig.class, ServerEndpoint.class, Endpoint.class})
public class WebSocketServerContainerInitializer
implements ServletContainerInitializer {
    public static final String ENABLE_KEY = "org.eclipse.jetty.websocket.jsr356";
    private static final Logger LOG = Log.getLogger(WebSocketServerContainerInitializer.class);

    public static ServerContainer configureContext(ServletContextHandler context) {
        WebSocketUpgradeFilter filter = WebSocketUpgradeFilter.configureContext((ServletContextHandler)context);
        ServerContainer jettyContainer = new ServerContainer((MappedWebSocketCreator)filter, filter.getFactory(), (Executor)context.getServer().getThreadPool());
        context.addBean((Object)jettyContainer);
        context.setAttribute(javax.websocket.server.ServerContainer.class.getName(), (Object)jettyContainer);
        return jettyContainer;
    }

    public static ServerContainer configureContext(ServletContext context, ServletContextHandler jettyContext) {
        WebSocketUpgradeFilter filter = WebSocketUpgradeFilter.configureContext((ServletContext)context);
        ServerContainer jettyContainer = new ServerContainer((MappedWebSocketCreator)filter, filter.getFactory(), (Executor)jettyContext.getServer().getThreadPool());
        jettyContext.addBean((Object)jettyContainer);
        context.setAttribute(javax.websocket.server.ServerContainer.class.getName(), (Object)jettyContainer);
        return jettyContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        Object enable = context.getAttribute(ENABLE_KEY);
        if (TypeUtil.isFalse((Object)enable)) {
            if (c.isEmpty()) {
                if (!LOG.isDebugEnabled()) return;
                LOG.debug("JSR-356 support disabled via attribute on context {} - {}", new Object[]{context.getContextPath(), context});
                return;
            } else {
                LOG.warn("JSR-356 support disabled via attribute on context {} - {}", new Object[]{context.getContextPath(), context});
            }
            return;
        }
        if (!TypeUtil.isTrue((Object)enable) && c.isEmpty()) {
            if (!LOG.isDebugEnabled()) return;
            LOG.debug("No JSR-356 annotations or interfaces discovered. JSR-356 support disabled", new Object[]{context.getContextPath(), context});
            return;
        }
        ContextHandler handler = ContextHandler.getContextHandler((ServletContext)context);
        if (handler == null) {
            throw new ServletException("Not running on Jetty, JSR-356 support disabled");
        }
        if (!(handler instanceof ServletContextHandler)) {
            throw new ServletException("Not running in Jetty ServletContextHandler, JSR-356 support disabled");
        }
        ServletContextHandler jettyContext = (ServletContextHandler)handler;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            ServerContainer jettyContainer = WebSocketServerContainerInitializer.configureContext(context, jettyContext);
            context.setAttribute(javax.websocket.server.ServerContainer.class.getName(), (Object)jettyContainer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} classes", (long)c.size());
            }
            HashSet<Class<? extends Endpoint>> discoveredExtendedEndpoints = new HashSet<Class<? extends Endpoint>>();
            HashSet discoveredAnnotatedEndpoints = new HashSet();
            HashSet<Class<? extends ServerApplicationConfig>> serverAppConfigs = new HashSet<Class<? extends ServerApplicationConfig>>();
            this.filterClasses(c, discoveredExtendedEndpoints, discoveredAnnotatedEndpoints, serverAppConfigs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Discovered {} extends Endpoint classes", (long)discoveredExtendedEndpoints.size());
                LOG.debug("Discovered {} @ServerEndpoint classes", (long)discoveredAnnotatedEndpoints.size());
                LOG.debug("Discovered {} ServerApplicationConfig classes", (long)serverAppConfigs.size());
            }
            boolean wasFiltered = false;
            HashSet deployableExtendedEndpointConfigs = new HashSet();
            HashSet deployableAnnotatedEndpoints = new HashSet();
            for (Class clazz : serverAppConfigs) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found ServerApplicationConfig: {}", new Object[]{clazz});
                }
                try {
                    Set annotatedClasses;
                    ServerApplicationConfig config = (ServerApplicationConfig)clazz.newInstance();
                    Set seconfigs = config.getEndpointConfigs(discoveredExtendedEndpoints);
                    if (seconfigs != null) {
                        wasFiltered = true;
                        deployableExtendedEndpointConfigs.addAll(seconfigs);
                    }
                    if ((annotatedClasses = config.getAnnotatedEndpointClasses(discoveredAnnotatedEndpoints)) == null) continue;
                    wasFiltered = true;
                    deployableAnnotatedEndpoints.addAll(annotatedClasses);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ServletException("Unable to instantiate: " + clazz.getName(), (Throwable)e);
                }
            }
            if (!wasFiltered) {
                deployableAnnotatedEndpoints.addAll(discoveredAnnotatedEndpoints);
                deployableExtendedEndpointConfigs = new HashSet();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} ServerEndpointConfig(s)", (long)deployableExtendedEndpointConfigs.size());
            }
            for (ServerEndpointConfig serverEndpointConfig : deployableExtendedEndpointConfigs) {
                try {
                    jettyContainer.addEndpoint(serverEndpointConfig);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} @ServerEndpoint(s)", (long)deployableAnnotatedEndpoints.size());
            }
            for (Class clazz : deployableAnnotatedEndpoints) {
                try {
                    jettyContainer.addEndpoint(clazz);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void filterClasses(Set<Class<?>> c, Set<Class<? extends Endpoint>> discoveredExtendedEndpoints, Set<Class<?>> discoveredAnnotatedEndpoints, Set<Class<? extends ServerApplicationConfig>> serverAppConfigs) {
        for (Class<?> clazz : c) {
            ServerEndpoint endpoint;
            if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                serverAppConfigs.add(clazz);
            }
            if (Endpoint.class.isAssignableFrom(clazz)) {
                discoveredExtendedEndpoints.add(clazz);
            }
            if ((endpoint = clazz.getAnnotation(ServerEndpoint.class)) == null) continue;
            discoveredAnnotatedEndpoints.add(clazz);
        }
    }
}

