/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.messages.AbstractMessageSink;

public class PartialStringMessageSink
extends AbstractMessageSink {
    private static final Logger LOG = Log.getLogger(PartialStringMessageSink.class);
    private Utf8StringBuilder utf;
    private int size;

    public PartialStringMessageSink(JavaxWebSocketSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
        Objects.requireNonNull(methodHandle, "MethodHandle");
        this.size = 0;
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (this.utf == null) {
                this.utf = new Utf8StringBuilder(1024);
            }
            if (frame.hasPayload()) {
                ByteBuffer payload = frame.getPayload();
                this.size += payload.remaining();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Raw Payload {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
                }
                this.utf.append(payload);
            }
            if (frame.isFin()) {
                this.methodHandle.invoke(this.utf.toString(), true);
                this.size = 0;
                this.utf = null;
            } else {
                this.methodHandle.invoke(this.utf.takePartialString(), false);
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
    }
}

