/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.core.CloseException;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.MessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.ByteBufferMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedMessageSink;

public class DecodedBinaryMessageSink<T>
extends DecodedMessageSink<Decoder.Binary<T>> {
    public DecodedBinaryMessageSink(JavaxWebSocketSession session, Decoder.Binary<T> decoder, MethodHandle methodHandle) throws NoSuchMethodException, IllegalAccessException {
        super(session, decoder, methodHandle);
    }

    @Override
    protected MethodHandle newRawMethodHandle() throws NoSuchMethodException, IllegalAccessException {
        return MethodHandles.lookup().findVirtual(DecodedBinaryMessageSink.class, "onWholeMessage", MethodType.methodType(Void.TYPE, ByteBuffer.class)).bindTo(this);
    }

    @Override
    protected MessageSink newRawMessageSink(JavaxWebSocketSession session, MethodHandle rawMethodHandle) {
        return new ByteBufferMessageSink(session, rawMethodHandle);
    }

    public void onWholeMessage(ByteBuffer wholeMessage) {
        if (!((Decoder.Binary)this.getDecoder()).willDecode(wholeMessage)) {
            this.logger.warn("Message lost, decoder " + ((Decoder.Binary)this.getDecoder()).getClass().getName() + "#willDecode() has rejected it.", new Object[0]);
            return;
        }
        try {
            Object obj = ((Decoder.Binary)this.getDecoder()).decode(wholeMessage);
            this.methodHandle.invoke(obj);
        }
        catch (DecodeException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", (Throwable)e);
        }
        catch (Throwable t) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Endpoint notification error", t);
        }
    }
}

