/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.time.Duration;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.OutgoingFrames;
import org.eclipse.jetty.websocket.core.WebSocketException;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.messages.MessageOutputStream;
import org.eclipse.jetty.websocket.javax.common.messages.MessageWriter;

public class JavaxWebSocketRemoteEndpoint
implements RemoteEndpoint,
OutgoingFrames {
    private static final Logger LOG = Log.getLogger(JavaxWebSocketRemoteEndpoint.class);
    protected final JavaxWebSocketSession session;
    private final FrameHandler.CoreSession coreSession;
    protected boolean batch = false;
    protected byte messageType = (byte)-1;

    protected JavaxWebSocketRemoteEndpoint(JavaxWebSocketSession session, FrameHandler.CoreSession coreSession) {
        this.session = session;
        this.coreSession = coreSession;
    }

    protected MessageWriter newMessageWriter() {
        return new MessageWriter(this.coreSession, this.coreSession.getOutputBufferSize());
    }

    protected MessageOutputStream newMessageOutputStream() {
        return new MessageOutputStream(this.coreSession, this.coreSession.getOutputBufferSize(), this.session.getContainerImpl().getBufferPool());
    }

    public void flushBatch() throws IOException {
        try (SharedBlockingCallback.Blocker blocker = this.session.getBlocking().acquire();){
            this.coreSession.flush((Callback)blocker);
        }
    }

    public boolean getBatchingAllowed() {
        return this.batch;
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
        if (this.batch && !allowed) {
            this.flushBatch();
        }
        this.batch = allowed;
    }

    public long getIdleTimeout() {
        return this.coreSession.getIdleTimeout().toMillis();
    }

    public void setIdleTimeout(long ms) {
        this.coreSession.setIdleTimeout(Duration.ofMillis(ms));
    }

    public long getWriteTimeout() {
        return this.coreSession.getWriteTimeout().toMillis();
    }

    public void setWriteTimeout(long ms) {
        this.coreSession.setWriteTimeout(Duration.ofMillis(ms));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendFrame(Frame frame, Callback callback, boolean batch) {
        if (frame.isDataFrame()) {
            try {
                byte opcode = frame.getOpCode();
                if (this.messageType == -1) {
                    if (opcode != 2 && opcode != 1) throw new WebSocketException("Encountered invalid Data Frame opcode " + opcode);
                    this.messageType = opcode;
                } else {
                    if (this.messageType == 2 && opcode == 1) {
                        throw new WebSocketException("Cannot start TEXT message when BINARY message is not complete yet");
                    }
                    if (this.messageType == 1 && opcode == 2) {
                        throw new WebSocketException("Cannot start BINARY message when TEXT message is not complete yet");
                    }
                }
            }
            catch (Throwable t) {
                callback.failed(t);
                return;
            }
        }
        try {
            this.coreSession.sendFrame(frame, callback, batch);
            return;
        }
        finally {
            if (frame.isFin()) {
                this.messageType = (byte)-1;
            }
        }
    }

    public void sendObject(Object data, Callback callback) throws IOException, EncodeException {
        try {
            Encoder encoder;
            this.assertMessageNotNull(data);
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendObject({}, {})", new Object[]{data, callback});
            }
            if ((encoder = this.session.getEncoders().getInstanceFor(data.getClass())) == null) {
                throw new IllegalArgumentException("No encoder for type: " + data.getClass());
            }
            if (encoder instanceof Encoder.Text) {
                Encoder.Text text = (Encoder.Text)encoder;
                String msg = text.encode(data);
                this.sendFrame(new Frame(1).setPayload(msg), callback, this.batch);
                return;
            }
            if (encoder instanceof Encoder.TextStream) {
                Encoder.TextStream etxt = (Encoder.TextStream)encoder;
                try (MessageWriter writer = this.newMessageWriter();){
                    writer.setCallback(callback);
                    etxt.encode(data, (Writer)writer);
                }
                return;
            }
            if (encoder instanceof Encoder.Binary) {
                Encoder.Binary ebin = (Encoder.Binary)encoder;
                ByteBuffer buf = ebin.encode(data);
                this.sendFrame(new Frame(2).setPayload(buf), callback, this.batch);
                return;
            }
            if (encoder instanceof Encoder.BinaryStream) {
                Encoder.BinaryStream ebin = (Encoder.BinaryStream)encoder;
                try (MessageOutputStream out = this.newMessageOutputStream();){
                    out.setCallback(callback);
                    ebin.encode(data, (OutputStream)out);
                }
                return;
            }
            throw new IllegalArgumentException("Unknown encoder type: " + encoder);
        }
        catch (IOException | RuntimeException | EncodeException e) {
            callback.failed(e);
            throw e;
        }
        catch (Throwable t) {
            callback.failed(t);
            LOG.warn("Unable to send Object " + data, t);
            return;
        }
    }

    public void sendPing(ByteBuffer data) throws IOException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPing({})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        this.sendFrame(new Frame(9).setPayload(data), Callback.NOOP, this.batch);
    }

    public void sendPong(ByteBuffer data) throws IOException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPong({})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        this.sendFrame(new Frame(10).setPayload(data), Callback.NOOP, this.batch);
    }

    protected void assertMessageNotNull(Object data) {
        if (data == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
    }

    protected void assertSendHandlerNotNull(SendHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("SendHandler cannot be null");
        }
    }
}

