/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.util.TextUtil;

public class JavaxWebSocketBasicRemote
extends JavaxWebSocketRemoteEndpoint
implements RemoteEndpoint.Basic {
    private static final Logger LOG = Log.getLogger(JavaxWebSocketBasicRemote.class);

    protected JavaxWebSocketBasicRemote(JavaxWebSocketSession session, FrameHandler.CoreSession coreSession) {
        super(session, coreSession);
    }

    public OutputStream getSendStream() throws IOException {
        return this.newMessageOutputStream();
    }

    public Writer getSendWriter() throws IOException {
        return this.newMessageWriter();
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        try (SharedBlockingCallback.Blocker b = this.session.getBlocking().acquire();){
            this.sendFrame(new Frame(2).setPayload(data), (Callback)b, false);
        }
    }

    public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
        this.assertMessageNotNull(partialByte);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", new Object[]{BufferUtil.toDetailString((ByteBuffer)partialByte), isLast});
        }
        try (SharedBlockingCallback.Blocker b = this.session.getBlocking().acquire();){
            Frame frame;
            switch (this.messageType) {
                case -1: {
                    frame = new Frame(2);
                    break;
                }
                case 1: {
                    throw new IllegalStateException("Cannot send a partial BINARY message: TEXT message in progress");
                }
                case 2: {
                    frame = new Frame(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot send a partial BINARY message: unrecognized active message type " + OpCode.name((byte)this.messageType));
                }
            }
            frame.setPayload(partialByte);
            frame.setFin(isLast);
            this.sendFrame(frame, (Callback)b, false);
        }
    }

    public void sendObject(Object data) throws IOException, EncodeException {
        try (SharedBlockingCallback.Blocker b = this.session.getBlocking().acquire();){
            super.sendObject(data, (Callback)b);
        }
    }

    public void sendText(String text) throws IOException {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", new Object[]{TextUtil.hint(text)});
        }
        try (SharedBlockingCallback.Blocker b = this.session.getBlocking().acquire();){
            this.sendFrame(new Frame(1).setPayload(text), (Callback)b, false);
        }
    }

    public void sendText(String partialMessage, boolean isLast) throws IOException {
        this.assertMessageNotNull(partialMessage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", new Object[]{TextUtil.hint(partialMessage), isLast});
        }
        try (SharedBlockingCallback.Blocker b = this.session.getBlocking().acquire();){
            Frame frame;
            switch (this.messageType) {
                case -1: {
                    frame = new Frame(1);
                    break;
                }
                case 1: {
                    frame = new Frame(0);
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Cannot send a partial TEXT message: BINARY message in progress");
                }
                default: {
                    throw new IllegalStateException("Cannot send a partial TEXT message: unrecognized active message type " + OpCode.name((byte)this.messageType));
                }
            }
            frame.setPayload(BufferUtil.toBuffer((String)partialMessage, (Charset)StandardCharsets.UTF_8));
            frame.setFin(isLast);
            this.sendFrame(frame, (Callback)b, false);
        }
    }
}

