/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.messages.AbstractMessageSink;

public class PartialByteBufferMessageSink
extends AbstractMessageSink {
    public PartialByteBufferMessageSink(JavaxWebSocketSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            ByteBuffer buffer;
            if (frame.hasPayload()) {
                ByteBuffer payload = frame.getPayload();
                buffer = ByteBuffer.allocate(payload.remaining());
                BufferUtil.clearToFill((ByteBuffer)buffer);
                BufferUtil.put((ByteBuffer)payload, (ByteBuffer)buffer);
                BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
            } else {
                buffer = BufferUtil.EMPTY_BUFFER;
            }
            this.methodHandle.invoke(buffer, frame.isFin());
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
    }
}

